/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class RewardsUtil {
    public static OffsetBlock[] fillArea(int xSize, int ySize, int zSize, Block block, int xOff, int yOff, int zOff, boolean falling, int delay, boolean causeUpdate, boolean relativeToPlayer) {
        ArrayList<OffsetBlock> toReturn = new ArrayList<OffsetBlock>();
        for (int y = 0; y < ySize; ++y) {
            for (int z = 0; z < zSize; ++z) {
                for (int x = 0; x < xSize; ++x) {
                    toReturn.add(new OffsetBlock(x + xOff, y + yOff, z + zOff, block, falling, delay).setCausesBlockUpdate(causeUpdate).setRelativeToPlayer(relativeToPlayer));
                }
            }
        }
        return toReturn.toArray(new OffsetBlock[toReturn.size()]);
    }

    public static OffsetBlock[] addBlocksLists(OffsetBlock[] ... lists) {
        int size = 0;
        for (OffsetBlock[] list : lists) {
            size += list.length;
        }
        OffsetBlock[] toReturn = new OffsetBlock[size];
        int i = 0;
        OffsetBlock[][] offsetBlockArray = lists;
        int n = offsetBlockArray.length;
        for (int j = 0; j < n; ++j) {
            OffsetBlock[] list;
            OffsetBlock[] offsetBlockArray2 = list = offsetBlockArray[j];
            int n2 = offsetBlockArray2.length;
            for (int k = 0; k < n2; ++k) {
                OffsetBlock osb;
                toReturn[i] = osb = offsetBlockArray2[k];
                ++i;
            }
        }
        return toReturn;
    }

    public static EntityPart[] spawnXEntities(NBTTagCompound entityNbt, int amount) {
        EntityPart[] toReturn = new EntityPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new EntityPart(entityNbt);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static ParticlePart[] spawnXParticles(String particle, int amount) {
        ParticlePart[] toReturn = new ParticlePart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new ParticlePart(particle);
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(World world, int x, int y, int z, int distance, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)x - entityplayer.field_70165_t, 2.0) + Math.pow((double)y - entityplayer.field_70163_u, 2.0) + Math.pow((double)z - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)distance)) continue;
            entityplayer.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            entityplayer.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static boolean placeBlock(Block b, World world, int x, int y, int z) {
        return RewardsUtil.placeBlock(b, world, x, y, z, 0);
    }

    public static boolean placeBlock(Block b, World world, int x, int y, int z, int meta) {
        return RewardsUtil.placeBlock(b, world, x, y, z, meta, 3);
    }

    public static boolean placeBlock(Block b, World world, int x, int y, int z, int meta, int update) {
        if (!RewardsUtil.isBlockUnbreakable(world, x, y, z)) {
            world.func_147465_d(x, y, z, b, meta, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) == -1.0f;
    }
}

