/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.rewards.giantRewards.BioDomeReward;
import chanceCubes.rewards.giantRewards.ChunkFlipReward;
import chanceCubes.rewards.giantRewards.ChunkReverserReward;
import chanceCubes.rewards.giantRewards.FloorIsLavaReward;
import chanceCubes.rewards.giantRewards.FluidTowerReward;
import chanceCubes.rewards.giantRewards.OrePillarReward;
import chanceCubes.rewards.giantRewards.OreSphereReward;
import chanceCubes.rewards.giantRewards.PotionsReward;
import chanceCubes.rewards.giantRewards.TNTSlingReward;
import chanceCubes.rewards.giantRewards.ThrowablesReward;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class GiantCubeRegistry
implements IRewardRegistry {
    public static GiantCubeRegistry INSTANCE = new GiantCubeRegistry();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();

    public static void loadDefaultRewards() {
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BioDomeReward());
        INSTANCE.registerReward(new TNTSlingReward());
        INSTANCE.registerReward(new ThrowablesReward());
        INSTANCE.registerReward(new OrePillarReward());
        INSTANCE.registerReward(new ChunkReverserReward());
        INSTANCE.registerReward(new FloorIsLavaReward());
        INSTANCE.registerReward(new ChunkFlipReward());
        INSTANCE.registerReward(new OreSphereReward());
        INSTANCE.registerReward(new PotionsReward());
        INSTANCE.registerReward(new FluidTowerReward());
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Giant Chance Cube Rewards", true, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        }
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward o = this.nameToReward.remove(name);
        if (o != null) {
            return this.sortedRewards.remove(o);
        }
        return false;
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    @Override
    public void triggerRandomReward(World world, int x, int y, int z, EntityPlayer player, int chance) {
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with the Giant Chance Cubes and no reward was able to be given");
            return;
        }
        int pick = world.field_73012_v.nextInt(this.sortedRewards.size());
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + this.sortedRewards.get(pick).getName());
        this.sortedRewards.get(pick).trigger(world, x, y, z, player);
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        Collections.sort(this.sortedRewards, new Comparator<IChanceCubeReward>(){

            @Override
            public int compare(IChanceCubeReward o1, IChanceCubeReward o2) {
                return o1.getChanceValue() - o2.getChanceValue();
            }
        });
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
    }
}

