/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TileMovingBase;
import com.rwtema.funkylocomotion.description.DescriptorRegistry;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.rendering.ChunkRerenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import framesapi.BlockPos;
import framesapi.IDescriptionProxy;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.shader.TesselatorVertexState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMovingClient
extends TileMovingBase {
    public static final HashMap<ChunkCoordinates, WeakReference<TileEntity>> cachedTiles = new HashMap();
    public static final HashSet<Class> renderBlackList = new HashSet();
    public static final HashSet<Class> renderErrorList = new HashSet();
    public Block block = Blocks.field_150350_a;
    public int meta = 0;
    public TileEntity tile = null;
    public boolean render;
    public boolean error = false;
    public boolean rawTile = false;
    public boolean init = false;
    public boolean failedToRenderInFirstPass = false;
    public final boolean[] skipPass = new boolean[2];
    public final TesselatorVertexState[] cachedState = new TesselatorVertexState[2];

    public TileMovingClient() {
        super(Side.CLIENT);
    }

    @Override
    public void func_145845_h() {
        if (this.time < this.maxTime) {
            super.func_145845_h();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.rawTile && this.tile != null) {
            this.tile.func_145843_s();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.block = Block.func_149729_e((int)tag.func_74762_e("Block"));
        this.meta = tag.func_74762_e("Meta");
        this.time = tag.func_74762_e("Time");
        this.maxTime = tag.func_74762_e("MaxTime");
        this.lightLevel = tag.func_74762_e("Light");
        this.lightOpacity = tag.func_74765_d("Opacity");
        boolean bl = this.isAir = this.block == Blocks.field_150350_a;
        if (tag.func_150297_b("Collisions", 9)) {
            this.collisions = TileMovingClient.AxisTags(tag.func_150295_c("Collisions", 10));
        }
        BlockHelper.postUpdateBlock(this.field_145850_b, new BlockPos(this));
        this.dir = ForgeDirection.getOrientation((int)tag.func_74771_c("Dir"));
        ChunkCoordinates key = new ChunkCoordinates(this.field_145851_c - this.dir.offsetX, this.field_145848_d - this.dir.offsetY, this.field_145849_e - this.dir.offsetZ);
        WeakReference<TileEntity> ref = cachedTiles.remove(key);
        if (ref != null) {
            this.tile = (TileEntity)ref.get();
        }
        if (this.tile != null && FakeWorldClient.isValid(this.field_145850_b) && this.tile.func_145831_w() == this.field_145850_b) {
            this.rawTile = true;
            this.tile.field_145851_c = this.field_145851_c;
            this.tile.field_145848_d = this.field_145848_d;
            this.tile.field_145849_e = this.field_145849_e;
            this.tile.field_145854_h = this.block;
            this.tile.field_145847_g = this.meta;
            this.tile.func_145834_a((World)FakeWorldClient.getFakeWorldWrapper(this.field_145850_b));
            this.tile = this.tile;
            this.render = true;
        } else {
            IDescriptionProxy d;
            boolean bl2 = this.render = !tag.func_74767_n("DNR");
            if (this.render && (d = DescriptorRegistry.getDescriptor(tag.func_74779_i("DescID"))) != null) {
                this.tile = d.recreateTileEntity(net, tag, this.block, this.meta, new BlockPos(this), this.func_145831_w());
            }
        }
        this.checkClass(this.block);
        if (this.checkClass(this.tile)) {
            this.tile = null;
        }
        if (this.render && !this.init) {
            ChunkRerenderer.markBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.init = true;
    }

    public boolean checkClass(Object o) {
        if (o == null) {
            return false;
        }
        if (renderBlackList.contains(o.getClass())) {
            this.render = false;
            return true;
        }
        if (renderErrorList.contains(o.getClass())) {
            this.render = false;
            this.error = true;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB other = this.tile != null ? this.tile.getRenderBoundingBox() : this.block.func_149668_a((World)FakeWorldClient.getFakeWorldWrapper(this.field_145850_b), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        other = other == null ? AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)) : other.func_111270_a(AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)));
        double h = this.offset(true);
        return other.func_72325_c(h * (double)this.dir.offsetX, h * (double)this.dir.offsetY, h * (double)this.dir.offsetZ);
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.maxTime == 0) {
            return false;
        }
        if (!this.render || this.error) {
            return pass == 0;
        }
        if (this.block == Blocks.field_150350_a || this.tile == null && this.block.func_149645_b() == -1) {
            return false;
        }
        if (pass == 1 && this.failedToRenderInFirstPass) {
            return true;
        }
        if (this.tile != null && this.tile.shouldRenderInPass(pass)) {
            return true;
        }
        return this.block.canRenderInPass(pass);
    }
}

