/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Library;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashSet;
import java.util.List;
import lumien.randomthings.Library.Interfaces.IValidator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldUtils {
    public static void setConnectedBlocksTo(World worldObj, int startX, int startY, int startZ, Block b, int metadata, Block originalBlock, int originalMetadata) {
        Block atPositionBlock = worldObj.func_147439_a(startX, startY, startZ);
        int atPositionMetadata = worldObj.func_72805_g(startX, startY, startZ);
        if (atPositionBlock == b && atPositionMetadata == metadata || atPositionBlock.isAir((IBlockAccess)worldObj, startX, startY, startZ)) {
            return;
        }
        if (atPositionBlock == originalBlock && atPositionMetadata == originalMetadata) {
            worldObj.func_147465_d(startX, startY, startZ, b, metadata, 2);
            try {
                WorldUtils.setConnectedBlocksTo(worldObj, startX, startY + 1, startZ, b, metadata, originalBlock, originalMetadata);
                WorldUtils.setConnectedBlocksTo(worldObj, startX, startY - 1, startZ, b, metadata, originalBlock, originalMetadata);
                WorldUtils.setConnectedBlocksTo(worldObj, startX + 1, startY, startZ, b, metadata, originalBlock, originalMetadata);
                WorldUtils.setConnectedBlocksTo(worldObj, startX - 1, startY, startZ, b, metadata, originalBlock, originalMetadata);
                WorldUtils.setConnectedBlocksTo(worldObj, startX, startY, startZ + 1, b, metadata, originalBlock, originalMetadata);
                WorldUtils.setConnectedBlocksTo(worldObj, startX, startY, startZ - 1, b, metadata, originalBlock, originalMetadata);
            }
            catch (StackOverflowError e) {
                return;
            }
        }
    }

    public static void dropItemStack(World world, double x, double y, double z, ItemStack stack) {
        if (!world.field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, x + d0, y + d1, z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void notifyStrong(World worldObj, int posX, int posY, int posZ, Block block) {
        worldObj.func_147459_d(posX, posY - 1, posZ, block);
        worldObj.func_147459_d(posX, posY + 1, posZ, block);
        worldObj.func_147459_d(posX - 1, posY, posZ, block);
        worldObj.func_147459_d(posX + 1, posY, posZ, block);
        worldObj.func_147459_d(posX, posY, posZ - 1, block);
        worldObj.func_147459_d(posX, posY, posZ + 1, block);
    }

    public static void generateCube(World worldObj, int posX1, int posY1, int posZ1, int posX2, int posY2, int posZ2, Block b, int metadata, int flag) {
        int minX = Math.min(posX1, posX2);
        int minY = Math.min(posY1, posY2);
        int minZ = Math.min(posZ1, posZ2);
        int maxX = Math.max(posX1, posX2);
        int maxY = Math.max(posY1, posY2);
        int maxZ = Math.max(posZ1, posZ2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && y != minY && z != minZ && x != maxX && y != maxY && z != maxZ) continue;
                    worldObj.func_147465_d(x, y, z, b, metadata, flag);
                }
            }
        }
    }

    public static boolean isPlayerOnline(String username) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username) != null;
        }
        NetHandlerPlayClient netclienthandler = Minecraft.func_71410_x().field_71439_g.field_71174_a;
        List list = netclienthandler.field_147303_b;
        for (int i = 0; i < list.size(); ++i) {
            GuiPlayerInfo guiplayerinfo = (GuiPlayerInfo)list.get(i);
            if (!guiplayerinfo.field_78831_a.toLowerCase().equals(username.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static HashSet<TileEntity> getConnectedTEs(World worldObj, int posX, int posY, int posZ, IValidator validator) {
        HashSet<TileEntity> tes = new HashSet<TileEntity>();
        WorldUtils.recConnectedTEs(tes, worldObj, posX, posY, posZ, validator);
        return tes;
    }

    public static void recConnectedTEs(HashSet<TileEntity> tes, World worldObj, int posX, int posY, int posZ, IValidator validator) {
        TileEntity te = worldObj.func_147438_o(posX, posY, posZ);
        if (te != null && !tes.contains(te) && validator.matches(te)) {
            tes.add(te);
            WorldUtils.recConnectedTEs(tes, worldObj, posX - 1, posY, posZ, validator);
            WorldUtils.recConnectedTEs(tes, worldObj, posX + 1, posY, posZ, validator);
            WorldUtils.recConnectedTEs(tes, worldObj, posX, posY + 1, posZ, validator);
            WorldUtils.recConnectedTEs(tes, worldObj, posX, posY - 1, posZ, validator);
            WorldUtils.recConnectedTEs(tes, worldObj, posX, posY, posZ + 1, validator);
            WorldUtils.recConnectedTEs(tes, worldObj, posX, posY, posZ - 1, validator);
        }
    }
}

