/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud.modules;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDProviderModule
implements IHUDModuleRenderer {
    private List<IHUDButton> buttons = new ArrayList<IHUDButton>();
    private int page = 0;
    private final ModuleProvider module;

    public HUDProviderModule(ModuleProvider moduleProvider) {
        this.buttons.add(new BasicHUDButton("<", 8, -35, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public void clicked() {
                HUDProviderModule.this.page--;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProviderModule.this.page > 0;
            }
        });
        this.buttons.add(new BasicHUDButton(">", 20, -35, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public void clicked() {
                HUDProviderModule.this.page++;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProviderModule.this.page + 1 < HUDProviderModule.this.getMaxPage();
            }
        });
        this.module = moduleProvider;
    }

    public int getMaxPage() {
        int ret = this.module.displayList.size() / 9;
        if (this.module.displayList.size() % 9 != 0 || ret == 0) {
            ++ret;
        }
        return ret;
    }

    @Override
    public void renderContent(boolean shifted) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0E-5f);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(this.module.displayList, null, this.page, -25, -24, 3, 9, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS, true, false, shifted);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-100000.0f);
    }

    @Override
    public List<IHUDButton> getButtons() {
        return this.buttons;
    }
}

