/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class CondenserSyncPKT
implements IMessage {
    private int displayEmc;
    private int requiredEmc;
    private int x;
    private int y;
    private int z;

    public CondenserSyncPKT() {
    }

    public CondenserSyncPKT(int displayEmc, int requiredEmc, int x, int y, int z) {
        this.displayEmc = displayEmc;
        this.requiredEmc = requiredEmc;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.displayEmc = buf.readInt();
        this.requiredEmc = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.displayEmc);
        buf.writeInt(this.requiredEmc);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static class Handler
    implements IMessageHandler<CondenserSyncPKT, IMessage> {
        public IMessage onMessage(CondenserSyncPKT pkt, MessageContext ctx) {
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(pkt.x, pkt.y, pkt.z);
            if (tile == null) {
                PELogger.logFatal("NULL tile entity reference in condenser update packet! Please report to dev!");
            } else {
                CondenserTile cond = (CondenserTile)tile;
                cond.displayEmc = pkt.displayEmc;
                cond.requiredEmc = pkt.requiredEmc;
            }
            return null;
        }
    }
}

