/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.utils.ComparatorHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class MatterFurnace
extends BlockDirection {
    private String textureName;
    private boolean isActive;
    private boolean isHighTier;
    private static boolean isUpdating;
    @SideOnly(value=Side.CLIENT)
    private IIcon front;
    private Random rand = new Random();

    public MatterFurnace(boolean active, boolean isRM) {
        super(Material.field_151576_e);
        this.func_149647_a(ObjHandler.cTab);
        this.isActive = active;
        this.isHighTier = isRM;
        this.textureName = this.isHighTier ? "rm" : "dm";
        this.func_149663_c("pe_" + this.textureName + "_furnace");
        if (this.isActive) {
            this.func_149647_a(null);
            this.func_149715_a(0.875f);
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0 ? 1000000.0f : 2000000.0f;
    }

    public Item func_149650_a(int no, Random rand, int clue) {
        return this.isHighTier ? Item.func_150898_a((Block)ObjHandler.rmFurnaceOff) : Item.func_150898_a((Block)ObjHandler.dmFurnaceOff);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (this.isHighTier) {
                player.openGui((Object)PECore.instance, 4, world, x, y, z);
            } else {
                player.openGui((Object)PECore.instance, 5, world, x, y, z);
            }
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int noclue) {
        if (!isUpdating) {
            IInventory tile = (IInventory)world.func_147438_o(x, y, z);
            if (tile == null) {
                return;
            }
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack stack = tile.func_70301_a(i);
                if (stack == null) continue;
                WorldHelper.spawnEntityItem(world, stack, x, y, z);
            }
            world.func_147453_f(x, y, z, block);
        }
        world.func_147475_p(x, y, z);
    }

    public void updateFurnaceBlockState(boolean isActive, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        isUpdating = true;
        if (isActive) {
            if (this.isHighTier) {
                world.func_147449_b(x, y, z, ObjHandler.rmFurnaceOn);
            } else {
                world.func_147449_b(x, y, z, ObjHandler.dmFurnaceOn);
            }
        } else if (this.isHighTier) {
            world.func_147449_b(x, y, z, ObjHandler.rmFurnaceOff);
        } else {
            world.func_147449_b(x, y, z, ObjHandler.dmFurnaceOff);
        }
        isUpdating = false;
        world.func_72921_c(x, y, z, meta, 2);
        if (tile != null) {
            tile.func_145829_t();
            world.func_147455_a(x, y, z, tile);
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entLiving, ItemStack stack) {
        this.setFacingMeta(world, x, y, z, (EntityPlayer)entLiving);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("ProjectEBlock") && tile instanceof TileEmc) {
            stack.field_77990_d.func_74768_a("x", x);
            stack.field_77990_d.func_74768_a("y", y);
            stack.field_77990_d.func_74768_a("z", z);
            stack.field_77990_d.func_74768_a("EMC", 0);
            stack.field_77990_d.func_74777_a("BurnTime", (short)0);
            stack.field_77990_d.func_74777_a("CookTime", (short)0);
            tile.func_145839_a(stack.field_77990_d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive) {
            int l = world.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("projecte:" + this.textureName);
        this.front = register.func_94245_a("projecte:matter_furnace/" + (this.isActive ? this.textureName + "_on" : this.textureName + "_off"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        return side != meta ? this.field_149761_L : this.front;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.isHighTier ? Item.func_150898_a((Block)ObjHandler.rmFurnaceOff) : Item.func_150898_a((Block)ObjHandler.dmFurnaceOff);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.isHighTier ? new RMFurnaceTile() : new DMFurnaceTile();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        return ComparatorHelper.getForMatterFurnace(world, x, y, z);
    }
}

