/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.impl.ConversionProxyImpl;
import net.minecraftforge.common.config.Configuration;

public class APICustomConversionMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    @Override
    public String getName() {
        return "APICustomConversionMapper";
    }

    @Override
    public String getDescription() {
        return "Allows other Mods to add Recipes to the EMC Calculation.";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        for (Map.Entry<String, List<ConversionProxyImpl.APIConversion>> entry : ConversionProxyImpl.instance.storedConversions.entrySet()) {
            if (!config.getBoolean(entry.getKey(), "allow", true, String.format("Allow Mod %s to add its %d Recipes to the EMC Calculation", entry.getKey(), entry.getValue().size()))) continue;
            for (ConversionProxyImpl.APIConversion apiConversion : entry.getValue()) {
                mapper.addConversion(apiConversion.amount, apiConversion.output, (Map<NormalizedSimpleStack, Integer>)apiConversion.ingredients);
            }
        }
    }
}

