/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MobRepulsorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_MOB_REPULSOR = "Mob Repulsor";
    public static final String MOB_REPULSOR_ENERGY_CONSUMPTION = "Repulsor Energy Consumption";

    public MobRepulsorModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(MOB_REPULSOR_ENERGY_CONSUMPTION, 250.0);
        this.addBaseProperty("Weight", 2000.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.magnet, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public String getTextureFile() {
        return "magneta";
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getDataName() {
        return MODULE_MOB_REPULSOR;
    }

    @Override
    public String getUnlocalizedName() {
        return "mobRepulsor";
    }

    @Override
    public String getDescription() {
        return "Pushes mobs away from you when activated, but constantly drains power. It is highly recommended that you set this module to a keybind because of the high energy draw.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(item, MOB_REPULSOR_ENERGY_CONSUMPTION)) {
            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(item, MOB_REPULSOR_ENERGY_CONSUMPTION));
            }
            this.repulse(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    public void repulse(World world, int i, int j, int k) {
        float distance = 5.0f;
        List list = world.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((float)i - distance), (double)((float)j - distance), (double)((float)k - distance), (double)((float)i + distance), (double)((float)j + distance), (double)((float)k + distance)));
        for (Entity entity : list) {
            this.push(entity, i, j, k);
        }
        list = world.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72330_a((double)((float)i - distance), (double)((float)j - distance), (double)((float)k - distance), (double)((float)i + distance), (double)((float)j + distance), (double)((float)k + distance)));
        for (Entity entity : list) {
            this.push(entity, i, j, k);
        }
        list = world.func_72872_a(EntityFireball.class, AxisAlignedBB.func_72330_a((double)((float)i - distance), (double)((float)j - distance), (double)((float)k - distance), (double)((float)i + distance), (double)((float)j + distance), (double)((float)k + distance)));
        for (Entity entity : list) {
            this.push(entity, i, j, k);
        }
        list = world.func_72872_a(EntityPotion.class, AxisAlignedBB.func_72330_a((double)((float)i - distance), (double)((float)j - distance), (double)((float)k - distance), (double)((float)i + distance), (double)((float)j + distance), (double)((float)k + distance)));
        for (Entity entity : list) {
            this.push(entity, i, j, k);
        }
    }

    private void push(Entity entity, int i, int j, int k) {
        if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityDragon)) {
            Entity entity2 = entity;
            double d = (double)i - entity2.field_70165_t;
            double d1 = (double)j - entity2.field_70163_u;
            double d2 = (double)k - entity2.field_70161_v;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if ((d4 *= d4) <= Math.pow(6.0, 4.0)) {
                double d5 = -(d * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                double d6 = -(d1 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                double d7 = -(d2 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                if (d5 > 0.0) {
                    d5 = 0.22;
                } else if (d5 < 0.0) {
                    d5 = -0.22;
                }
                if (d6 > 0.2) {
                    d6 = 0.12;
                } else if (d6 < -0.1) {
                    d6 = 0.12;
                }
                if (d7 > 0.0) {
                    d7 = 0.22;
                } else if (d7 < 0.0) {
                    d7 = -0.22;
                }
                entity2.field_70159_w += d5;
                entity2.field_70181_x += d6;
                entity2.field_70179_y += d7;
            }
        }
    }
}

