/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util.inventory;

import com.mordenkainen.equivalentenergistics.util.inventory.IInvChangeNotifier;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InternalInventory
implements IInventory {
    private static final String SLOT_TAG = "Slot";
    public ItemStack[] slots;
    public String customName;
    private final int stackLimit;
    private final IInvChangeNotifier te;

    public InternalInventory(String customName, int size, int stackLimit, IInvChangeNotifier te) {
        this.slots = new ItemStack[size];
        this.customName = customName;
        this.stackLimit = stackLimit;
        this.te = te;
    }

    public InternalInventory(String customName, int size, int stackLimit) {
        this(customName, size, stackLimit, null);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        ItemStack slotStack = this.slots[slotId];
        if (slotStack == null) {
            return null;
        }
        int decAmount = Math.min(amount, slotStack.field_77994_a);
        int remAmount = slotStack.field_77994_a - decAmount;
        if (remAmount > 0) {
            this.slots[slotId].field_77994_a = remAmount;
        } else {
            this.slots[slotId] = null;
        }
        ItemStack resultStack = null;
        if (decAmount > 0) {
            resultStack = slotStack.func_77946_l();
            resultStack.field_77994_a = decAmount;
        }
        this.func_70296_d();
        return resultStack;
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack stack = this.func_70301_a(slotId);
        this.func_70299_a(slotId, null);
        return stack;
    }

    public void func_70299_a(int slotId, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.slots[slotId] = itemStack;
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public void func_70296_d() {
        if (this.te != null && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.te.onChangeInventory();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        return true;
    }

    public final void loadFromNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        if (!data.func_74764_b(tagName)) {
            return;
        }
        this.slots = new ItemStack[this.slots.length];
        NBTTagList invList = data.func_150295_c(tagName, 10);
        for (int index = 0; index < invList.func_74745_c(); ++index) {
            NBTTagCompound nbtCompound = invList.func_150305_b(index);
            int slotIndex = nbtCompound.func_74771_c(SLOT_TAG) & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.slots.length) continue;
            this.slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
        }
    }

    public final void saveToNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        NBTTagList invList = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.slots.length; ++slotIndex) {
            if (this.slots[slotIndex] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a(SLOT_TAG, (byte)slotIndex);
            this.slots[slotIndex].func_77955_b(nbtCompound);
            invList.func_74742_a((NBTBase)nbtCompound);
        }
        if (invList.func_74745_c() > 0) {
            data.func_74782_a(tagName, (NBTBase)invList);
        }
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (this.func_70301_a(x) == null) continue;
            return false;
        }
        return true;
    }
}

