/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.EMCGridCellHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.EMCGridCrystalHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.IEMCStorageGrid;
import com.mordenkainen.equivalentenergistics.util.EMCPool;

public class EMCStorageGrid
implements IEMCStorageGrid {
    private final IGrid grid;
    private final EMCPool pool = new EMCPool();
    private final EMCGridCellHandler cellHandler = new EMCGridCellHandler(this);
    private final EMCGridCrystalHandler crystalHandler = new EMCGridCrystalHandler(this);

    public EMCStorageGrid(IGrid grid) {
        this.grid = grid;
    }

    @MENetworkEventSubscribe
    public void afterCacheConstruction(MENetworkPostCacheConstruction cacheConstruction) {
        ((IStorageGrid)this.grid.getCache(IStorageGrid.class)).registerCellProvider((ICellProvider)this.crystalHandler);
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate cellUpdate) {
        this.cellHandler.cellUpdate(cellUpdate);
    }

    public void onUpdateTick() {
        this.crystalHandler.updateDisplay();
    }

    public void removeNode(IGridNode gridNode, IGridHost machine) {
        this.cellHandler.removeNode(gridNode, machine);
    }

    public void addNode(IGridNode gridNode, IGridHost machine) {
        this.cellHandler.addNode(gridNode, machine);
    }

    @Override
    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public double getCurrentEMC() {
        return this.pool.getCurrentEMC();
    }

    @Override
    public double getMaxEMC() {
        return this.pool.getMaxEMC();
    }

    @Override
    public double getAvail() {
        return this.pool.getAvail();
    }

    @Override
    public boolean isFull() {
        return this.pool.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    @Override
    public void setCurrentEMC(double currentEMC) {
        this.pool.setCurrentEMC(currentEMC);
    }

    @Override
    public void setMaxEMC(double maxEMC) {
        this.pool.setMaxEMC(maxEMC);
    }

    @Override
    public double addEMC(double emc) {
        return this.pool.addEMC(emc);
    }

    @Override
    public double addEMC(double emc, Actionable mode) {
        return this.cellHandler.injectEMC(emc, mode);
    }

    @Override
    public double extractEMC(double emc) {
        return this.pool.extractEMC(emc);
    }

    @Override
    public double extractEMC(double emc, Actionable mode) {
        return this.cellHandler.extractEMC(emc, mode);
    }

    public void markDirty() {
        this.crystalHandler.markDirty();
    }
}

