/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.EMCStorageGrid;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystalOld;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EMCGridCrystalHandler
implements ICellProvider,
IMEInventoryHandler<IAEItemStack> {
    private final EMCStorageGrid hostGrid;
    private boolean dirty = true;
    private IItemList<IAEItemStack> cachedList = AEApi.instance().storage().createItemList();

    public EMCGridCrystalHandler(EMCStorageGrid hostGrid) {
        this.hostGrid = hostGrid;
    }

    public IAEItemStack injectItems(IAEItemStack stack, Actionable mode, BaseActionSource src) {
        int toAdd;
        double itemEMC = 0.0;
        if (ItemEnum.EMCCRYSTAL.isSameItem(stack.getItemStack())) {
            itemEMC = Integration.emcHandler.getCrystalEMC(stack.getItemDamage());
        } else if (ItemEnum.EMCCRYSTALOLD.isSameItem(stack.getItemStack())) {
            itemEMC = ItemEMCCrystalOld.CRYSTAL_VALUES[stack.getItemDamage()];
        }
        if (itemEMC > 0.0 && (toAdd = (int)Math.min((double)stack.getStackSize(), this.hostGrid.getAvail() / itemEMC)) > 0) {
            this.hostGrid.addEMC((double)toAdd * itemEMC, mode);
            return (long)toAdd == stack.getStackSize() ? null : (IAEItemStack)stack.copy().setStackSize(stack.getStackSize() - (long)toAdd);
        }
        return stack;
    }

    public IAEItemStack extractItems(IAEItemStack stack, Actionable mode, BaseActionSource src) {
        int toRemove;
        double itemEMC = 0.0;
        if (ItemEnum.EMCCRYSTAL.isSameItem(stack.getItemStack())) {
            itemEMC = Integration.emcHandler.getCrystalEMC(stack.getItemDamage());
        } else if (ItemEnum.EMCCRYSTALOLD.isSameItem(stack.getItemStack())) {
            itemEMC = ItemEMCCrystalOld.CRYSTAL_VALUES[stack.getItemDamage()];
        }
        if (itemEMC > 0.0 && (toRemove = (int)Math.min((double)stack.getStackSize(), this.hostGrid.getCurrentEMC() / itemEMC)) > 0) {
            this.hostGrid.extractEMC((double)toRemove * itemEMC, mode);
            return (IAEItemStack)stack.copy().setStackSize((long)toRemove);
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> items) {
        for (IAEItemStack stack : this.cachedList) {
            items.add((IAEStack)stack);
        }
        return items;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack stack) {
        return ItemEnum.isCrystal(stack.getItemStack());
    }

    public boolean canAccept(IAEItemStack stack) {
        return ItemEnum.isCrystal(stack.getItemStack());
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int pass) {
        return pass == 1;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (channel == StorageChannel.ITEMS) {
            return new ArrayList<IMEInventoryHandler>(Arrays.asList(this));
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public int getPriority() {
        return 0x7FFFFFFE;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void updateDisplay() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        IStorageGrid storageGrid = (IStorageGrid)this.hostGrid.getGrid().getCache(IStorageGrid.class);
        for (IAEItemStack stack : this.cachedList) {
            stack.setStackSize(-stack.getStackSize());
        }
        storageGrid.postAlterationOfStoredItems(StorageChannel.ITEMS, this.cachedList, new BaseActionSource());
        this.cachedList = AEApi.instance().storage().createItemList();
        if (this.hostGrid.getCurrentEMC() > 0.0) {
            double remainingEMC = this.hostGrid.getCurrentEMC();
            for (int i = 4; i >= 0; --i) {
                double crystalEMC = Integration.emcHandler.getCrystalEMC(i);
                long crystalcount = (long)(remainingEMC / crystalEMC);
                if (crystalcount <= 0L) continue;
                this.cachedList.add(AEApi.instance().storage().createItemStack(ItemEnum.EMCCRYSTAL.getDamagedStack(i)).setStackSize(crystalcount));
                remainingEMC -= (double)crystalcount * crystalEMC;
            }
        }
        this.cachedList.add(AEApi.instance().storage().createItemStack(ItemEnum.MISCITEM.getDamagedStack(1)).setStackSize((long)this.hostGrid.getCurrentEMC()));
        storageGrid.postAlterationOfStoredItems(StorageChannel.ITEMS, this.cachedList, new BaseActionSource());
    }
}

