/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser.tiles;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import com.mordenkainen.equivalentenergistics.blocks.BlockEnum;
import com.mordenkainen.equivalentenergistics.blocks.condenser.BlockEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.condenser.CondenserState;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserAdv;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import com.mordenkainen.equivalentenergistics.util.inventory.InternalInventory;
import com.mordenkainen.equivalentenergistics.util.inventory.InvUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEMCCondenserExt
extends TileEMCCondenserAdv {
    private static final String SIDE_TAG = "sides";
    private final Map<ForgeDirection, SideSetting> sides = new HashMap<ForgeDirection, SideSetting>();

    public TileEMCCondenserExt() {
        this(new ItemStack(Item.func_150898_a((Block)BlockEnum.EMCCONDENSER.getBlock()), 1, 2));
    }

    public TileEMCCondenserExt(ItemStack repItem) {
        super(repItem);
        this.internalInventory = new InternalInventory("EMCCondenserInventory", 4, 64);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.sides.put(side, SideSetting.NONE);
        }
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        if (this.isActive()) {
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.updateState(CondenserState.IDLE);
                return TickRateModulation.IDLE;
            }
            this.importItems();
        }
        return super.tickingRequest(node, ticksSinceLast);
    }

    protected void importItems() {
        int numItems = this.itemsToTransfer();
        for (ForgeDirection side : this.sides.keySet()) {
            if (this.sides.get(side) != SideSetting.INPUT) continue;
            IInventory sourceInv = CommonUtils.getTE(IInventory.class, (IBlockAccess)this.field_145850_b, this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (sourceInv != null) {
                numItems -= InvUtils.extractWithCount(side.getOpposite(), sourceInv, this.getInventory(), numItems);
            }
            if (numItems > 0) continue;
            break;
        }
    }

    @Override
    protected double getEMCPerTick() {
        return BlockEMCCondenser.emcPerTick * 100.0;
    }

    @Override
    protected ItemStack ejectItem(ItemStack stack) {
        int numItems = this.itemsToTransfer();
        for (ForgeDirection side : this.sides.keySet()) {
            if (this.sides.get(side) != SideSetting.OUTPUT) continue;
            IInventory destInv = CommonUtils.getTE(IInventory.class, (IBlockAccess)this.field_145850_b, this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (destInv != null) {
                int ejected = InvUtils.ejectStack(stack, destInv, side.getOpposite(), numItems);
                numItems -= ejected;
                stack.field_77994_a -= ejected;
            }
            if (numItems > 0) continue;
            break;
        }
        if (stack.field_77994_a > 0) {
            return super.ejectItem(stack);
        }
        return null;
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        NBTTagCompound list = new NBTTagCompound();
        for (ForgeDirection side : this.sides.keySet()) {
            list.func_74768_a(side.name(), this.sides.get(side).ordinal());
        }
        nbttagcompound.func_74782_a(SIDE_TAG, (NBTBase)list);
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        boolean flag = super.readPacketData(nbttagcompound);
        NBTTagCompound list = (NBTTagCompound)nbttagcompound.func_74781_a(SIDE_TAG);
        for (ForgeDirection side : this.sides.keySet()) {
            SideSetting newData = SideSetting.values()[list.func_74762_e(side.name())];
            if (newData == this.sides.get(side)) continue;
            this.sides.put(side, newData);
            flag = true;
        }
        return flag;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        NBTTagCompound list = (NBTTagCompound)data.func_74781_a(SIDE_TAG);
        if (list != null) {
            for (ForgeDirection side : this.sides.keySet()) {
                this.sides.put(side, SideSetting.values()[list.func_74762_e(side.name())]);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        NBTTagCompound list = new NBTTagCompound();
        for (ForgeDirection side : this.sides.keySet()) {
            list.func_74768_a(side.name(), this.sides.get(side).ordinal());
        }
        data.func_74782_a(SIDE_TAG, (NBTBase)list);
    }

    public void toggleSide(int side) {
        ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
        this.sides.put(forgeSide, this.sides.get(forgeSide).getNext());
        this.markForUpdate();
    }

    public SideSetting getSide(int side) {
        return this.sides.get(ForgeDirection.getOrientation((int)side));
    }

    protected int itemsToTransfer() {
        return 16;
    }

    public static enum SideSetting {
        NONE,
        INPUT,
        OUTPUT;


        public SideSetting getNext() {
            int setting = this.ordinal() + 1;
            if (setting >= 3) {
                setting = 0;
            }
            return SideSetting.values()[setting];
        }
    }
}

