/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.blocks.base.block.BlockMultiContainerBase;
import com.mordenkainen.equivalentenergistics.blocks.base.block.ILayeredBlock;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserAdv;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserBase;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserExt;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserUlt;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class BlockEMCCondenser
extends BlockMultiContainerBase
implements IConfigurable,
ILayeredBlock {
    private static final String GROUP = "Condenser";
    public static double emcPerTick;
    public static double idlePower;
    public static double activePower;

    public BlockEMCCondenser() {
        super(Material.field_151576_e, 4);
        this.func_149711_c(1.5f);
        this.func_149672_a(Block.field_149769_e);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return EquivalentEnergistics.proxy.layeredRenderer;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEMCCondenser();
            }
            case 1: {
                return new TileEMCCondenserAdv();
            }
            case 2: {
                return new TileEMCCondenserExt();
            }
        }
        return new TileEMCCondenserUlt();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return TextureEnum.EMCCONDENSER.getTexture(meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEMCCondenserExt tileCondenser;
        if (player == null) {
            return false;
        }
        if (player.func_70694_bm() == null && (tileCondenser = CommonUtils.getTE(TileEMCCondenserExt.class, (IBlockAccess)world, x, y, z)) != null && !world.field_72995_K) {
            tileCondenser.toggleSide(side);
            return true;
        }
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        if (meta == 0) {
            return 0;
        }
        TileEMCCondenserAdv tile = CommonUtils.getTE(TileEMCCondenserAdv.class, (IBlockAccess)world, x, y, z);
        switch (tile.getState()) {
            case ACTIVE: {
                return 2;
            }
            case IDLE: {
                return 1;
            }
            case NOEMCSTORAGE: {
                return 3;
            }
            case NOITEMSTORAGE: {
                return 4;
            }
            case NOPOWER: {
                return 5;
            }
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) != 0;
    }

    @Override
    public int numLayers(Block block, int meta) {
        return 0;
    }

    @Override
    public int numLayers(IBlockAccess world, Block block, int x, int y, int z, int meta) {
        return 2;
    }

    @Override
    public IIcon getLayer(Block block, int side, int meta, int layer) {
        return null;
    }

    @Override
    public IIcon getLayer(IBlockAccess world, Block block, int x, int y, int z, int side, int meta, int layer) {
        TileEMCCondenserBase tileCondenser = CommonUtils.getTE(TileEMCCondenserBase.class, world, x, y, z);
        if (tileCondenser != null) {
            if (layer == 1) {
                if (tileCondenser.getState().isError()) {
                    return TextureEnum.EMCCONDENSEROVL.getTexture(3);
                }
                if (tileCondenser.isActive()) {
                    return TextureEnum.EMCCONDENSEROVL.getTexture(2);
                }
            } else if (tileCondenser instanceof TileEMCCondenserExt) {
                if (((TileEMCCondenserExt)tileCondenser).getSide(side) == TileEMCCondenserExt.SideSetting.INPUT) {
                    return TextureEnum.EMCCONDENSEROVL.getTexture();
                }
                if (((TileEMCCondenserExt)tileCondenser).getSide(side) == TileEMCCondenserExt.SideSetting.OUTPUT) {
                    return TextureEnum.EMCCONDENSEROVL.getTexture(1);
                }
            }
        }
        return null;
    }

    @Override
    public void loadConfig(Configuration config) {
        idlePower = config.get(GROUP, "IdlePowerDrain", 0.0).getDouble(0.0);
        activePower = config.get(GROUP, "PowerDrainPerEMCCondensed", 0.01).getDouble(0.01);
        emcPerTick = config.get(GROUP, "EMCProducedPerTick", 8192).getDouble(8192.0);
        ConfigCategory condenserCat = config.getCategory(GROUP.toLowerCase(Locale.US));
        condenserCat.remove((Object)"CrystalsProducedPerTick");
        condenserCat.remove((Object)"ItemsCondensedPerTick");
    }
}

