/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.mammals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityPregnantPig
implements IExtendedEntityProperties {
    public static final String PREGNANT_PIG_PROPERTY = "EntityPregnantPigJC";
    private String dnaSequence = "";
    private String mammalName = "noEmbryo";
    private int pregnancyProgress;
    private int pregnancySpeed = 0;
    private int dnaQuality = 0;

    public static final void register(EntityPig entity) {
        entity.registerExtendedProperties(PREGNANT_PIG_PROPERTY, (IExtendedEntityProperties)new EntityPregnantPig());
    }

    public static final EntityPregnantPig get(EntityPig entity) {
        return (EntityPregnantPig)entity.getExtendedProperties(PREGNANT_PIG_PROPERTY);
    }

    public void init(Entity entity, World world) {
    }

    public String getDNASequence() {
        return this.dnaSequence;
    }

    public void setDNASequence(String dna) {
        this.dnaSequence = dna;
    }

    public String getMammalName() {
        return this.mammalName;
    }

    public void setMammalName(String mammal) {
        this.mammalName = mammal;
    }

    public int getPregnancyProgress() {
        return this.pregnancyProgress;
    }

    public void setPregnancyProgress(int progress) {
        this.pregnancyProgress = progress;
    }

    public void increasePregnancyProgress() {
        this.pregnancyProgress = this.getPregnancyProgress() + 1;
    }

    public int getPregnancySpeed() {
        return this.pregnancySpeed;
    }

    public void setPregnancySpeed(int speed) {
        this.pregnancySpeed = speed;
    }

    public int getDNAQuality() {
        return this.dnaQuality;
    }

    public void setDNAQuality(int quality) {
        this.dnaQuality = quality;
    }

    public int getPregnancyProgressScaled(int barSize) {
        if (this.getPregnancySpeed() <= 0) {
            this.setPregnancySpeed(2048);
        }
        return this.getPregnancyProgress() * barSize / this.getPregnancySpeed();
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74778_a("DNASequence", this.dnaSequence);
        properties.func_74778_a("MammalName", this.mammalName);
        properties.func_74768_a("PregnancyProgress", this.pregnancyProgress);
        properties.func_74768_a("PregnancySpeed", this.pregnancySpeed);
        properties.func_74768_a("DNAQuality", this.dnaQuality);
        compound.func_74782_a(PREGNANT_PIG_PROPERTY, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(PREGNANT_PIG_PROPERTY);
        if (properties != null) {
            if (properties.func_74764_b("DNASequence")) {
                this.dnaSequence = properties.func_74779_i("DNASequence");
            }
            if (properties.func_74764_b("MammalName")) {
                this.mammalName = properties.func_74779_i("MammalName");
            }
            if (properties.func_74764_b("PregnancyProgress")) {
                this.pregnancyProgress = properties.func_74762_e("PregnancyProgress");
            }
            if (properties.func_74764_b("PregnancySpeed")) {
                this.pregnancySpeed = properties.func_74762_e("PregnancySpeed");
            }
            if (properties.func_74764_b("DNAQuality")) {
                this.dnaQuality = properties.func_74762_e("DNAQuality");
            }
        }
    }
}

