/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.ilexiconn.jurassicraft.common.api.IAnimatedEntity;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.ilexiconn.jurassicraft.common.handler.JurassiCraftDNAHandler;
import net.ilexiconn.jurassicraft.common.item.ItemGrowthSerum;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityJurassiCraftCreature
extends EntityCreature
implements IEntityAdditionalSpawnData,
IAnimatedEntity {
    private Creature creature;
    protected final HashSet<Integer> growthStageList = new HashSet();
    public int frame;
    public int expParameter;
    protected float geneticQuality;
    protected boolean gender;
    protected byte texture;
    protected int animID;
    protected int animTick;
    private float heightParameter;
    private float lengthParameter;
    private float bBoxXZ;
    private float bBoxY;

    public EntityJurassiCraftCreature(World world) {
        super(world);
        this.setCreature(CreatureHandler.classToCreature(this.getClass()));
        if (this.getGeneticQuality() < 0.6f || this.getGeneticQuality() >= 1.4f) {
            this.setRandomGenetics();
        }
        this.resetGrowthStageList();
        this.setCreatureGender(JurassiCraftDNAHandler.getDefaultGenderDNAQuality(this.getDNASequence()) == 0.5f ? this.field_70146_Z.nextBoolean() : JurassiCraftDNAHandler.getDefaultGenderDNAQuality(this.getDNASequence()) > 0.5f);
        this.setNewCreatureTexture(JurassiCraftDNAHandler.getDefaultTextureDNAQuality(this.getDNASequence()));
        this.updateCreatureData(this.getTotalTicksLived());
        this.animTick = 0;
        this.animID = 0;
    }

    public boolean func_70094_T() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            int j = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f));
            if (!this.field_70170_p.func_147439_a(j, k = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70131_O + (double)f1)), l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f2))).func_149721_r()) continue;
            return true;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)String.valueOf(""));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public Creature getCreature() {
        return this.creature;
    }

    public void setCreature(Creature creature) {
        this.creature = creature;
    }

    public float getGeneticQuality() {
        return this.geneticQuality;
    }

    private void setGeneticQuality(float quality) {
        this.geneticQuality = quality;
    }

    public String getDNASequence() {
        return this.field_70180_af.func_75681_e(14);
    }

    public void setDNASequence(String dna) {
        this.field_70180_af.func_75692_b(14, (Object)String.valueOf(dna));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
        }
        ++this.frame;
    }

    public void func_70636_d() {
        if ((double)this.getTotalTicksLived() <= this.getCreature().getTicksToAdulthood() && this.growthStageList.contains(this.getTotalTicksLived())) {
            if (this.getGrowthStage() < 120) {
                this.setGrowthStage((byte)(this.getGrowthStage() + 1));
            }
            if (this.getCreature() != null) {
                this.updateCreatureData(this.getTotalTicksLived());
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70154_o != null) {
            this.func_70624_b(null);
        }
        super.func_70636_d();
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemGrowthSerum && this.forceCreatureGrowth(player, (byte)10) && !player.field_71075_bZ.field_75098_d) {
            --player.func_70694_bm().field_77994_a;
        }
        return super.func_70085_c(player);
    }

    public void showDebugInfo(EntityPlayer player) {
        System.out.println("");
        System.out.println("=============== UPDATE DATA ===============");
        if (this.field_70170_p.field_72995_K) {
            System.out.println("================= Client ==================");
            if (player != null && player.func_70694_bm() != null) {
                System.out.println("Held item = " + player.func_70694_bm().func_77977_a());
            }
            if (this instanceof EntityJurassiCraftSmart) {
                System.out.println("Owner: " + ((EntityJurassiCraftSmart)this).getOwnerName() + ", isTamed: " + ((EntityJurassiCraftSmart)this).isTamed());
            }
            System.out.println("Health: " + this.getCreatureHealth());
            System.out.println("Attack: " + this.getCreatureAttack());
            System.out.println("Speed: " + this.getCreatureSpeed());
            System.out.println("Knockback: " + this.getCreatureKnockback());
            System.out.println("Length: " + this.getCreatureLength());
            System.out.println("Height: " + this.getCreatureHeight());
            System.out.println("Scale: " + this.getCreatureScale());
            System.out.println("Genetic Quality: " + this.getGeneticQuality() + ", DNASequence: " + this.getDNASequence() + ". Revised DNA for 50% " + JurassiCraftDNAHandler.reviseDNA(this.getDNASequence(), 50));
            System.out.println("Gender: " + this.getCreatureGenderString() + ". Genetic for gender: " + JurassiCraftDNAHandler.getDefaultGenderDNAQuality(this.getDNASequence()));
            System.out.println("Texture number: " + this.getCreatureTexture() + ". Genetic for texture: " + JurassiCraftDNAHandler.getDefaultTextureDNAQuality(this.getDNASequence()));
            System.out.println("Adult: " + this.isCreatureAdult());
            System.out.println("===========================================");
        } else {
            System.out.println("================= Server ==================");
            if (player != null && player.func_70694_bm() != null) {
                System.out.println("Held item = " + player.func_70694_bm().func_77977_a());
            }
            if (this instanceof EntityJurassiCraftSmart) {
                System.out.println("Owner: " + ((EntityJurassiCraftSmart)this).getOwnerName() + ", isTamed: " + ((EntityJurassiCraftSmart)this).isTamed());
            }
            System.out.println("Health: " + this.getCreatureHealth());
            System.out.println("Attack: " + this.getCreatureAttack());
            System.out.println("Speed: " + this.getCreatureSpeed());
            System.out.println("Knockback: " + this.getCreatureKnockback());
            System.out.println("Length: " + this.getCreatureLength());
            System.out.println("Height: " + this.getCreatureHeight());
            System.out.println("Scale: " + this.getCreatureScale());
            System.out.println("Genetic Quality: " + this.getGeneticQuality() + ", DNASequence: " + this.getDNASequence() + ". Revised DNA for 50% " + JurassiCraftDNAHandler.reviseDNA(this.getDNASequence(), 50));
            System.out.println("Gender: " + this.getCreatureGenderString() + ". Genetic for gender: " + JurassiCraftDNAHandler.getDefaultGenderDNAQuality(this.getDNASequence()));
            System.out.println("Texture number: " + this.getCreatureTexture() + ". Genetic for texture: " + JurassiCraftDNAHandler.getDefaultTextureDNAQuality(this.getDNASequence()));
            System.out.println("Adult: " + this.isCreatureAdult());
            System.out.println("===========================================");
            System.out.println("");
        }
    }

    protected void updateCreatureData(int ticks) {
        if (ticks > 0) {
            double ticksToAdulthood = this.getCreature().getTicksToAdulthood();
            double minHealth = this.getCreature().getMinHealth();
            double minStrength = this.getCreature().getMinStrength();
            double minSpeed = this.getCreature().getMinSpeed();
            double minKnockback = this.getCreature().getMinKnockback();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((int)((double)this.getGeneticQuality() * ((double)ticks * this.getCreature().getMaxHealth() - minHealth) / ticksToAdulthood + minHealth)));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((float)((double)this.getGeneticQuality() * ((double)ticks * (this.getCreature().getMaxStrength() - minStrength) / ticksToAdulthood + minStrength))));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)((float)((double)ticks * (this.getCreature().getMaxSpeed() - minSpeed) / ticksToAdulthood + minSpeed)));
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)((float)((double)this.getGeneticQuality() * ((double)ticks * (this.getCreature().getMaxKnockback() - minKnockback) / ticksToAdulthood + minKnockback))));
            this.setBoundingBox((float)((double)this.getGeneticQuality() * (this.getCreature().getXzBoxMin() + this.getCreature().getXzBoxDelta() * (double)((float)this.getGrowthStage() / 120.0f))), (float)((double)this.getGeneticQuality() * (this.getCreature().getYBoxMin() + this.getCreature().getYBoxDelta() * (double)((float)this.getGrowthStage() / 120.0f))));
            this.setCreatureLength();
            this.setCreatureHeight();
            this.setCreatureSize(this.getXZBoundingBox(), this.getYBouningBox());
            this.setCreatureScale();
            this.func_70691_i((float)(this.getCreatureHealth() - (double)this.field_70735_aL));
        }
    }

    private void resetGrowthStageList() {
        int ticks = (int)this.getCreature().getTicksToAdulthood();
        this.growthStageList.add(1);
        for (int i = 1; i < 120; i = (int)((byte)(i + 1))) {
            this.growthStageList.add(ticks * i / 120);
        }
        this.growthStageList.add(ticks);
    }

    public byte getGrowthStage() {
        return this.field_70180_af.func_75683_a(13);
    }

    private void setGrowthStage(byte stage) {
        this.field_70180_af.func_75692_b(13, (Object)stage);
    }

    public void setBoundingBox(float xz, float y) {
        this.bBoxXZ = xz;
        this.bBoxY = y;
    }

    protected final void setCreatureSize(float xzBoundingBox, float yBouningBox) {
        super.func_70105_a(xzBoundingBox, yBouningBox);
    }

    public float getCreatureScale() {
        return this.field_70180_af.func_111145_d(12) * this.getCreature().getScaleAdjustment();
    }

    private void setCreatureScale(float scale) {
        if (scale > 0.0f) {
            this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(scale));
        } else {
            this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(0.0f));
        }
    }

    private void setCreatureScale() {
        if ((double)this.getTotalTicksLived() < this.getCreature().getTicksToAdulthood()) {
            float maxHeight = this.getCreature().getMaxHeight();
            float minHeight = this.getCreature().getMinHeight();
            float maxLength = this.getCreature().getMaxLength();
            float minLength = this.getCreature().getMinLength();
            this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(this.getGeneticQuality() * ((minLength + minHeight) / 2.0f + ((maxHeight + maxLength) / 2.0f - (minHeight + minLength) / 2.0f) * ((float)this.getTotalTicksLived() / (float)this.getCreature().getTicksToAdulthood())) / ((maxHeight + maxLength) / 2.0f)));
        } else {
            this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(this.getGeneticQuality()));
        }
    }

    public int getTotalTicksLived() {
        return this.field_70173_aa;
    }

    private void setTicksExisted(int ticks) {
        this.field_70173_aa = ticks;
    }

    public boolean forceCreatureGrowth(EntityPlayer player, byte growthIncrease) {
        if (this.getGrowthStage() + growthIncrease <= 120) {
            this.setGrowthStage((byte)(this.getGrowthStage() + growthIncrease));
            this.setTicksExisted((int)(this.getCreature().getTicksToAdulthood() * (double)this.getGrowthStage() / 120.0));
            if (this.getCreature() != null) {
                this.updateCreatureData(this.getTotalTicksLived());
            }
            return true;
        }
        if (player != null && player.field_70170_p.field_72995_K) {
            if (this.func_94056_bM()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.interaction.fullGrown")));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.interaction.fullGrown")));
            }
        }
        return false;
    }

    public void setFullGrowth() {
        if (!this.isCreatureAdult()) {
            this.setGrowthStage((byte)120);
            this.setTicksExisted((int)(this.getCreature().getTicksToAdulthood() * (double)this.getGrowthStage() / 120.0));
            if (this.getCreature() != null) {
                this.updateCreatureData(this.getTotalTicksLived());
            }
        }
    }

    public void setNoGrowth() {
        if (this.getGrowthStage() != 0) {
            this.setGrowthStage((byte)0);
            this.setTicksExisted(0);
            if (this.getCreature() != null) {
                this.updateCreatureData(this.getTotalTicksLived());
            }
        }
    }

    public String getCreatureName() {
        return this.getCreature().getCreatureName();
    }

    public boolean hasDNASequence() {
        return this.getDNASequence() != null && this.getDNASequence() != "";
    }

    public void setGenetics(int dnaQuality, String dna) {
        this.setDNASequence(JurassiCraftDNAHandler.reviseDNA(dna, dnaQuality));
        this.setGeneticQuality(JurassiCraftDNAHandler.getDefaultGeneticDNAQuality(dna));
    }

    public void setRandomGenetics() {
        String dna = JurassiCraftDNAHandler.createDefaultDNA();
        this.setGeneticQuality(JurassiCraftDNAHandler.getDefaultGeneticDNAQuality(dna));
        this.setDNASequence(dna);
    }

    public float getAdultAge() {
        return (float)this.getCreature().getTicksToAdulthood();
    }

    public boolean isCreatureAdult() {
        return (float)this.getTotalTicksLived() >= this.getCreature().getAdultAge() * this.getAdultAge();
    }

    public boolean isCreatureOlderThan(float percentage) {
        return (double)this.getTotalTicksLived() >= (double)percentage * this.getCreature().getTicksToAdulthood();
    }

    public float getXZBoundingBox() {
        return this.bBoxXZ;
    }

    public float getYBouningBox() {
        return this.bBoxY;
    }

    public double getCreatureCurrentHealth() {
        return (double)((int)(100.0f * this.func_110143_aJ())) / 100.0;
    }

    public double getCreatureHealth() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e())) / 100.0;
    }

    public int getCreatureHealthScaled(int i) {
        return (int)(this.getCreatureHealth() * (double)i / ((double)1.2f * this.getCreature().getMaxHealth()));
    }

    public double getCreatureAttack() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) / 100.0;
    }

    public int getCreatureAttackScaled(int i) {
        return (int)(this.getCreatureAttack() * (double)i / ((double)1.2f * this.getCreature().getMaxStrength()));
    }

    public double getCreatureSpeed() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e())) / 100.0;
    }

    public int getCreatureSpeedScaled(int i) {
        return (int)(this.getCreatureSpeed() * (double)i / ((double)1.2f * this.getCreature().getMaxSpeed()));
    }

    public double getCreatureKnockback() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e())) / 100.0;
    }

    public int getCreatureKnockbackScaled(int i) {
        return (int)(this.getCreatureKnockback() * (double)i / ((double)1.2f * this.getCreature().getMaxKnockback()));
    }

    public float getCreatureLength() {
        return (float)((int)(100.0f * this.lengthParameter)) / 100.0f;
    }

    public int getCreatureLengthScaled(int i) {
        return (int)(this.getCreatureLength() * (float)i / (1.2f * this.getCreature().getMaxLength()));
    }

    public float getCreatureHeight() {
        return (float)((int)(this.heightParameter * 100.0f) / 100) - 0.25f;
    }

    public int getCreatureHeightScaled(int i) {
        return (int)(this.getCreatureHeight() * (float)i / (1.2f * this.getCreature().getMaxHeight()));
    }

    public boolean isMale() {
        return this.getCreatureGender();
    }

    public String getCreatureGenderString() {
        return this.getCreatureGender() ? "Male" : "Female";
    }

    public boolean getCreatureGender() {
        return this.gender;
    }

    public void setCreatureGender(boolean sex) {
        this.gender = sex;
    }

    private void setNewCreatureTexture(float textureFromGenetics) {
        int textureCount = this.getCreature().getTextureCount();
        if (textureCount > 0) {
            float texturesInterval = 0.8f / (float)textureCount;
            for (int i = 1; i <= textureCount; ++i) {
                if (!(textureFromGenetics <= 0.2f + texturesInterval * (float)i)) continue;
                this.texture = (byte)(i - 1);
                return;
            }
        }
        this.texture = 0;
    }

    public byte getCreatureTexture() {
        return this.texture;
    }

    private void setCreatureTexture(byte texture) {
        this.texture = texture;
    }

    public void setCreatureLength() {
        this.lengthParameter = (double)this.getTotalTicksLived() <= this.getCreature().getTicksToAdulthood() ? (float)((double)this.getGeneticQuality() * ((double)this.getCreature().getMinLength() + (double)((float)this.getTotalTicksLived() * (this.getCreature().getMaxLength() - this.getCreature().getMinLength())) / this.getCreature().getTicksToAdulthood())) : this.getGeneticQuality() * this.getCreature().getMaxLength();
    }

    public void setCreatureHeight() {
        this.heightParameter = (double)this.getTotalTicksLived() <= this.getCreature().getTicksToAdulthood() ? (float)((double)this.getGeneticQuality() * ((double)this.getCreature().getMinHeight() + (double)((float)this.getTotalTicksLived() * (this.getCreature().getMaxHeight() - this.getCreature().getMinHeight())) / this.getCreature().getTicksToAdulthood())) : this.getGeneticQuality() * this.getCreature().getMaxHeight();
    }

    public int getCreatureAgeInDays() {
        return this.getTotalTicksLived() / 24000;
    }

    public int getCreatureAgeInMonths() {
        return this.getTotalTicksLived() / 720000;
    }

    public int getCreatureAgeInYears() {
        return this.getTotalTicksLived() / 8640000;
    }

    public String getCreatureAgeString() {
        byte years = (byte)this.getCreatureAgeInYears();
        byte months = (byte)(this.getCreatureAgeInMonths() - 12 * this.getCreatureAgeInYears());
        byte days = (byte)(this.getCreatureAgeInDays() - 30 * this.getCreatureAgeInMonths());
        String yearString = StatCollector.func_74838_a((String)"container.pad.years");
        String monthString = StatCollector.func_74838_a((String)"container.pad.months");
        String dayString = StatCollector.func_74838_a((String)"container.pad.days");
        if (years <= 1) {
            yearString = StatCollector.func_74838_a((String)"container.pad.year");
        }
        if (months <= 1) {
            monthString = StatCollector.func_74838_a((String)"container.pad.month");
        }
        if (days <= 1) {
            dayString = StatCollector.func_74838_a((String)"container.pad.day");
        }
        if (years <= 0) {
            if (months <= 0) {
                return String.valueOf(days) + " " + dayString;
            }
            return String.valueOf(months) + " " + monthString + String.valueOf(days) + " " + dayString;
        }
        if (months <= 0) {
            return String.valueOf(years) + " " + yearString + String.valueOf(days) + " " + dayString;
        }
        return String.valueOf(years) + " " + yearString + String.valueOf(months) + " " + monthString + String.valueOf(days) + " " + dayString;
    }

    public float func_70047_e() {
        return this.getCreatureHeight() * 0.85f;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected float func_70647_i() {
        return Float.valueOf(1.0f + 0.8f * (float)(120 - this.getGrowthStage()) / 120.0f).floatValue();
    }

    protected float func_70599_aP() {
        return Float.valueOf(0.7f + 0.3f * (float)this.getGrowthStage() / 120.0f).floatValue();
    }

    public int getCreatureExperiencePoints() {
        return this.expParameter;
    }

    public void setCreatureExperiencePoints(int points) {
        this.expParameter = points;
    }

    protected int func_70693_a(EntityPlayer player) {
        return (int)((float)this.getCreatureExperiencePoints() * this.getGeneticQuality() * (float)this.getGrowthStage() / 120.0f);
    }

    public boolean isWaterCreature() {
        return this.getCreature().isWaterCreature();
    }

    public boolean isFlyingCreature() {
        return this.getCreature().isFlyingCreature();
    }

    @Override
    public int getAnimationId() {
        return this.animID;
    }

    @Override
    public void setAnimationId(int id) {
        this.animID = id;
    }

    @Override
    public int getAnimationTick() {
        return this.animTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animTick = tick;
    }

    public String func_70639_aQ() {
        this.func_85030_a("jurassicraft:" + this.getCreatureName().toLowerCase() + ":living", this.func_70599_aP(), this.func_70647_i());
        return null;
    }

    public String func_70621_aR() {
        this.func_85030_a("jurassicraft:" + this.getCreatureName().toLowerCase() + ":hurt", this.func_70599_aP(), this.func_70647_i());
        return null;
    }

    public String func_70673_aS() {
        this.func_85030_a("jurassicraft:" + this.getCreatureName().toLowerCase() + ":death", this.func_70599_aP(), this.func_70647_i());
        return null;
    }

    protected EntityItem dropItemStackWithGenetics(ItemStack stack) {
        if (stack.func_77973_b() != null) {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.hasDNASequence()) {
                compound.func_74778_a("DNA", this.getDNASequence());
            } else {
                compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            }
            compound.func_74768_a("Quality", 100);
            stack.func_77982_d(compound);
        }
        return this.func_70099_a(stack, 0.0f);
    }

    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), 1));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), 1);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ID", this.getCreature().getCreatureID());
        compound.func_74768_a("TicksExisted", this.getTotalTicksLived());
        compound.func_74774_a("GrowthStage", this.getGrowthStage());
        compound.func_74778_a("DNASequence", this.getDNASequence());
        compound.func_74776_a("GeneticQuality", this.getGeneticQuality());
        compound.func_74757_a("Gender", this.getCreatureGender());
        compound.func_74774_a("Texture", this.getCreatureTexture());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCreature(CreatureHandler.getCreatureFromId(compound.func_74771_c("ID")));
        this.setTicksExisted(compound.func_74762_e("TicksExisted"));
        this.setGrowthStage(compound.func_74771_c("GrowthStage"));
        this.setDNASequence(compound.func_74779_i("DNASequence"));
        this.setGeneticQuality(compound.func_74760_g("GeneticQuality"));
        this.setCreatureGender(compound.func_74767_n("Gender"));
        this.setCreatureTexture(compound.func_74771_c("Texture"));
        this.resetGrowthStageList();
        this.updateCreatureData(this.getTotalTicksLived());
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeByte((int)this.getCreature().getCreatureID());
        buf.writeInt(this.getTotalTicksLived());
        buf.writeByte((int)this.getGrowthStage());
        buf.writeFloat(this.getGeneticQuality());
        buf.writeBoolean(this.getCreatureGender());
        buf.writeByte((int)this.getCreatureTexture());
    }

    public void readSpawnData(ByteBuf buf) {
        try {
            this.setCreature(CreatureHandler.getCreatureFromId(buf.readByte()));
            this.setTicksExisted(buf.readInt());
            this.setGrowthStage(buf.readByte());
            this.setGeneticQuality(buf.readFloat());
            this.setCreatureGender(buf.readBoolean());
            this.setCreatureTexture(buf.readByte());
            this.resetGrowthStageList();
            this.updateCreatureData(this.getTotalTicksLived());
        }
        catch (Exception e) {
            System.err.println("Error while reading dino spawn data!");
            e.printStackTrace();
        }
    }
}

