/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.mob;

import fossilsarcheology.server.entity.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.EntityToyBase;
import fossilsarcheology.server.entity.ai.DinoAIAttackOnCollide;
import fossilsarcheology.server.entity.ai.DinoAIEatFeeders;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoAIWaterFindTarget;
import fossilsarcheology.server.enums.EnumPrehistoric;
import fossilsarcheology.server.enums.EnumPrehistoricAI;
import fossilsarcheology.server.item.FAItemRegistry;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySarcosuchus
extends EntityPrehistoricSwimming {
    public static Animation ROLL_ANIMATION = Animation.create((int)115);
    private boolean isSwimming;
    public float swimProgress;

    public EntitySarcosuchus(World world) {
        super(world, EnumPrehistoric.Sarcosuchus, 1.0, 3.0, 15.0, 70.0, 0.25, 0.25);
        this.setActualSize(2.0f, 1.0f);
        this.isAmphibious = true;
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DinoAIWaterFindTarget(this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.5, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIEatFeeders(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIEatItems(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DinoAIHunt((EntityCreature)this, 20, false));
        this.minSize = 0.2f;
        this.maxSize = 2.3f;
        this.teenAge = 5;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.hasBabyTexture = true;
        this.ridingY = 1.2f;
        this.pediaScale = 30.0f;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public EnumPrehistoricAI.Activity aiActivityType() {
        return EnumPrehistoricAI.Activity.BOTH;
    }

    @Override
    public EnumPrehistoricAI.Attacking aiAttackType() {
        return EnumPrehistoricAI.Attacking.DROWN;
    }

    @Override
    public EnumPrehistoricAI.Climbing aiClimbType() {
        return EnumPrehistoricAI.Climbing.NONE;
    }

    @Override
    public EnumPrehistoricAI.Following aiFollowType() {
        return EnumPrehistoricAI.Following.AGRESSIVE;
    }

    @Override
    public EnumPrehistoricAI.Jumping aiJumpType() {
        return EnumPrehistoricAI.Jumping.BASIC;
    }

    @Override
    public EnumPrehistoricAI.Response aiResponseType() {
        return EnumPrehistoricAI.Response.AGRESSIVE;
    }

    @Override
    public EnumPrehistoricAI.Stalking aiStalkType() {
        return EnumPrehistoricAI.Stalking.NONE;
    }

    @Override
    public EnumPrehistoricAI.Taming aiTameType() {
        return EnumPrehistoricAI.Taming.BLUEGEM;
    }

    @Override
    public EnumPrehistoricAI.Untaming aiUntameType() {
        return EnumPrehistoricAI.Untaming.NONE;
    }

    @Override
    public EnumPrehistoricAI.Moving aiMovingType() {
        return EnumPrehistoricAI.Moving.SEMIAQUATIC;
    }

    @Override
    public EnumPrehistoricAI.WaterAbility aiWaterAbilityType() {
        return EnumPrehistoricAI.WaterAbility.ATTACK;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.INSTANCE.skullStick;
    }

    @Override
    public int getAdultAge() {
        return 12;
    }

    @Override
    public int getMaxHunger() {
        return 150;
    }

    @Override
    protected double getSwimSpeed() {
        return 2.0;
    }

    @Override
    public void func_70043_V() {
        if (this.getRidingPlayer() != null && this.func_152114_e((EntityLivingBase)this.getRidingPlayer())) {
            super.func_70043_V();
            return;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && !this.func_152114_e((EntityLivingBase)this.field_70153_n)) {
            if (this.getAnimationTick() % 20 == 0 && this.field_70153_n != null) {
                this.field_70153_n.func_70097_a(DamageSource.field_76369_e, 10.0f);
                if (this.field_70153_n instanceof EntityToyBase) {
                    ((EntityToyBase)this.field_70153_n).func_110145_l((Entity)this);
                }
                if (this.field_70153_n.field_70128_L) {
                    this.func_70074_a((EntityLivingBase)this.field_70153_n);
                }
            }
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
            this.field_70177_z *= 0.0f;
            this.field_70153_n.field_70177_z = this.field_70177_z + this.field_70759_as + 180.0f;
            this.field_70177_z = this.field_70761_aq;
            float radius = -0.7f * (0.7f * this.getAgeScale()) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + 0.15750001f;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = 0.5f * this.getAgeScale();
            this.field_70153_n.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean swimming = this.isSwimming();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        }
        if (this.isSwimming() && (this.func_70906_o() || this.isSleeping())) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (this.func_70638_az() != null && this.getAttackBounds().func_72326_a(this.func_70638_az().field_70121_D)) {
            if (!this.func_70090_H()) {
                if (this.getAnimation() != this.ATTACK_ANIMATION) {
                    this.setAnimation(this.ATTACK_ANIMATION);
                }
                if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() > 5) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
                this.func_70652_k((Entity)this.func_70638_az());
            } else {
                this.func_70638_az().func_70078_a((Entity)this);
                if (this.getAnimation() != ROLL_ANIMATION) {
                    this.setAnimation(ROLL_ANIMATION);
                }
            }
        }
        if (this.isInWaterMaterial()) {
            this.setSwimming(true);
        } else {
            this.setSwimming(false);
        }
    }

    @Override
    public int getAttackLength() {
        return 15;
    }

    public boolean func_70652_k(Entity entityIn) {
        return !this.func_70090_H();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, ROLL_ANIMATION};
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Swimming", this.isSwimming);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwimming(compound.func_74767_n("Swimming"));
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSwimming;
            this.isSwimming = isSwimming = (this.field_70180_af.func_75683_a(29) & 1) != 0;
            return isSwimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        byte b0 = this.field_70180_af.func_75683_a(29);
        if (swimming) {
            this.field_70180_af.func_75692_b(29, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(29, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    @Override
    protected String func_70639_aQ() {
        return this.func_70631_g_() ? "fossil:sarcosuchus_baby_living" : "fossil:sarcosuchus_living";
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }
}

