/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.mob;

import fossilsarcheology.Revival;
import fossilsarcheology.client.gui.GuiPedia;
import fossilsarcheology.server.entity.IViviparous;
import fossilsarcheology.server.enums.EnumPrehistoric;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityPregnantSheep
implements IViviparous,
IExtendedEntityProperties {
    public static final String PREGNANT_SHEEP_PROP = "EntityPregnantSheep";
    public final EntitySheep sheep;
    public int embryoProgress;
    public EnumPrehistoric embryo;

    public EntityPregnantSheep(EntitySheep sheep) {
        this.sheep = sheep;
        this.embryoProgress = 0;
        this.embryo = null;
    }

    public static final void register(EntitySheep entity) {
        entity.registerExtendedProperties(PREGNANT_SHEEP_PROP, (IExtendedEntityProperties)new EntityPregnantSheep(entity));
    }

    public static final EntityPregnantSheep get(EntitySheep entity) {
        return (EntityPregnantSheep)entity.getExtendedProperties(PREGNANT_SHEEP_PROP);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("EmbryoProgress", this.embryoProgress);
        if (this.embryo != null) {
            compound.func_74774_a("Inside", (byte)this.embryo.ordinal());
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("EmbryoProgress")) {
            this.embryoProgress = compound.func_74762_e("EmbryoProgress");
        }
        if (compound.func_74764_b("Inside")) {
            this.embryo = EnumPrehistoric.values()[compound.func_74771_c("Inside")];
        }
    }

    public void init(Entity entity, World world) {
    }

    @Override
    public void setEmbryo(EnumPrehistoric animalType) {
        this.embryo = animalType;
    }

    public void setPedia() {
        Revival.toPedia = this;
    }

    @Override
    public void showPedia(GuiPedia pedia) {
        if (this.embryo != null) {
            int progress = (int)Math.floor((float)this.embryoProgress / (float)this.embryo.growTime * 100.0f);
            pedia.reset();
            pedia.addStringLR(StatCollector.func_74838_a((String)"pedia.embryo.inside"), false);
            pedia.addStringLR(StatCollector.func_74838_a((String)("pedia.embryo." + this.embryo.toString())), false, 40, 90, 245);
            pedia.addStringLR(StatCollector.func_74838_a((String)"pedia.embryo.growing"), false);
            pedia.addStringLR(String.valueOf(progress) + "/100", false);
        } else {
            pedia.reset();
            pedia.addStringLR(StatCollector.func_74838_a((String)"pedia.embryo.inside"), false);
            pedia.addStringLR(StatCollector.func_74838_a((String)"pedia.embryo.growing"), false);
        }
    }
}

