/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.ai;

import fossilsarcheology.api.FoodMappings;
import fossilsarcheology.server.entity.EntityPrehistoric;
import fossilsarcheology.server.entity.EntityToyBase;
import fossilsarcheology.server.enums.EnumPrehistoricMood;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.EnumDifficulty;

public class DinoAIHunt
extends EntityAITarget {
    private final int targetTicks;
    private final Sorter theNearestAttackableTargetSorter;
    private final IEntitySelector targetEntitySelector;
    private EntityLivingBase targetEntity;

    public DinoAIHunt(EntityCreature prehistoric, int ticks, boolean sight) {
        this(prehistoric, ticks, sight, false);
    }

    public DinoAIHunt(EntityCreature prehistoric, int ticks, boolean sight, boolean nearby) {
        this(prehistoric, ticks, sight, nearby, null);
    }

    public DinoAIHunt(EntityCreature prehistoric, int ticks, boolean sight, boolean nearby, final IEntitySelector selector) {
        super(prehistoric, sight, nearby);
        this.targetTicks = ticks;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)prehistoric);
        this.func_75248_a(1);
        this.targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity target) {
                return !(target instanceof EntityLivingBase) ? false : (selector != null && !selector.func_82704_a(target) ? false : DinoAIHunt.this.func_75296_a((EntityLivingBase)target, false));
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetTicks > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetTicks) != 0) {
            return false;
        }
        double d0 = this.func_111175_f();
        List list = this.field_75299_d.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_75299_d.field_70121_D.func_72314_b(d0, 4.0, d0), this.targetEntitySelector);
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        if (list.isEmpty()) {
            return false;
        }
        this.targetEntity = (EntityLivingBase)list.get(0);
        if (this.field_75299_d instanceof EntityPrehistoric) {
            EntityPrehistoric prehistoric = (EntityPrehistoric)this.field_75299_d;
            if (this.targetEntity instanceof EntityPlayer && ((EntityPlayer)this.targetEntity).field_71075_bZ.field_75098_d) {
                return false;
            }
            if (this.targetEntity instanceof EntityPlayer) {
                if (this.field_75299_d.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                    return false;
                }
                if (prehistoric.getMood() < 0 && prehistoric.getMoodFace() != EnumPrehistoricMood.CALM) {
                    return !((EntityPlayer)this.targetEntity).field_71075_bZ.field_75098_d;
                }
                if (prehistoric.getMood() > 25 && prehistoric.getMoodFace() != EnumPrehistoricMood.CALM) {
                    return false;
                }
                if (prehistoric.getMoodFace() == EnumPrehistoricMood.CALM) {
                    return !prehistoric.func_152114_e(this.targetEntity) && prehistoric.canDinoHunt((Entity)this.targetEntity, true);
                }
            }
            if (FoodMappings.INSTANCE.getEntityFoodAmount(this.targetEntity.getClass(), prehistoric.type.diet) > 0) {
                return !prehistoric.func_152114_e(this.targetEntity) && prehistoric.canDinoHunt((Entity)this.targetEntity, true);
            }
            if (this.targetEntity instanceof EntityToyBase && prehistoric.ticksTillPlay == 0) {
                return true;
            }
            if (prehistoric.func_70610_aX() || !prehistoric.canDinoHunt((Entity)this.targetEntity, true)) {
                return false;
            }
        }
        return true;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator {
        private final Entity theEntity;

        public Sorter(Entity entity) {
            this.theEntity = entity;
        }

        public int compare(Entity entity, Entity entity1) {
            double d1;
            double d0 = this.theEntity.func_70068_e(entity);
            return d0 < (d1 = this.theEntity.func_70068_e(entity1)) ? -1 : (d0 > d1 ? 1 : 0);
        }

        public int compare(Object entity, Object entity1) {
            return this.compare((Entity)entity, (Entity)entity1);
        }
    }
}

