/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity;

import fossilsarcheology.server.entity.EntityPrehistoric;
import fossilsarcheology.server.enums.EnumPrehistoric;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityPrehistoricFlying
extends EntityPrehistoric {
    public ChunkCoordinates field_70776_bF;
    public static final int FLYING_INDEX = 29;
    private boolean isFlying;
    public float flyProgress;
    private int ticksFlying;

    public EntityPrehistoricFlying(World world, EnumPrehistoric type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed) {
        super(world, type, baseDamage, maxDamage, baseHealth, maxHealth, baseSpeed, maxSpeed);
    }

    public boolean isDirectPathBetweenPoints(Vec3 vec1, Vec3 vec2) {
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72901_a(vec1, Vec3.func_72443_a((double)vec2.field_72450_a, (double)(vec2.field_72448_b + (double)this.field_70131_O * 0.5), (double)vec2.field_72449_c), false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Flying", this.isFlying);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            boolean isFlying;
            this.isFlying = isFlying = (this.field_70180_af.func_75683_a(29) & 1) != 0;
            return isFlying;
        }
        return this.isFlying;
    }

    public void func_70664_aZ() {
        super.func_70664_aZ();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean flying = this.isFlying();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        }
        if (!this.isFlying() && !this.func_70610_aX() && this.field_70146_Z.nextInt(400) == 0 && !this.field_70170_p.field_72995_K && this.isAdult() && this.field_70153_n == null && this.field_70122_E) {
            this.setFlying(true);
        }
        if (this.ticksFlying > 80 && this.field_70122_E) {
            this.setFlying(false);
        }
        if (!this.isFlying() && this.field_70776_bF != null && !this.field_70122_E) {
            this.setFlying(true);
        }
        if (this.isFlying() && this.func_70777_m() == null) {
            this.flyAround();
            ++this.ticksFlying;
        } else if (this.func_70777_m() != null) {
            this.flyTowardsTarget();
        }
    }

    @Override
    public boolean canSleep() {
        if (super.canSleep() && this.isFlying() && this.field_70122_E) {
            this.setFlying(false);
            return super.canSleep();
        }
        return super.canSleep();
    }

    public void setFlying(boolean flying) {
        byte b0 = this.field_70180_af.func_75683_a(29);
        if (flying) {
            this.field_70180_af.func_75692_b(29, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(29, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public Vec3 getPosition() {
        return Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
    }

    public void flyAround() {
        if (this.field_70776_bF != null) {
            if (!this.isDirectPathBetweenPoints(this.getPosition(), Vec3.func_72443_a((double)this.field_70776_bF.field_71574_a, (double)this.field_70776_bF.field_71572_b, (double)this.field_70776_bF.field_71573_c))) {
                this.field_70776_bF = null;
            }
            if (!this.isTargetInAir() || this.func_70011_f(this.field_70776_bF.field_71574_a, this.field_70776_bF.field_71572_b, this.field_70776_bF.field_71573_c) < 3.0 || this.ticksFlying > 6000) {
                this.field_70776_bF = null;
            }
            this.flyTowardsTarget();
        }
    }

    public void flyTowardsTarget() {
        if (this.field_70776_bF != null && this.isTargetInAir() && this.isFlying() && this.getDistanceSquared(Vec3.func_72443_a((double)this.field_70776_bF.field_71574_a, (double)this.field_70163_u, (double)this.field_70776_bF.field_71573_c)) > 3.0f) {
            double targetX = (double)this.field_70776_bF.field_71574_a + 0.5 - this.field_70165_t;
            double targetY = (double)this.field_70776_bF.field_71572_b + 1.0 - this.field_70163_u;
            double targetZ = (double)this.field_70776_bF.field_71573_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * this.getFlySpeed();
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * this.getFlySpeed();
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * this.getFlySpeed();
            float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += rotation;
        } else {
            this.field_70776_bF = null;
        }
    }

    protected boolean isTargetInAir() {
        return this.field_70776_bF != null && this.field_70170_p.func_147439_a(this.field_70776_bF.field_71574_a, this.field_70776_bF.field_71572_b, this.field_70776_bF.field_71573_c).func_149688_o() == Material.field_151579_a && this.field_70170_p.func_147439_a(this.field_70776_bF.field_71574_a, this.field_70776_bF.field_71572_b + 1, this.field_70776_bF.field_71573_c).func_149688_o() == Material.field_151579_a;
    }

    public float getDistanceSquared(Vec3 vec) {
        float f = (float)(this.field_70165_t - vec.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean isDirectPathBetweenPoints(ChunkCoordinates vec1, ChunkCoordinates vec2) {
        return vec1.func_82371_e(vec2) > 20.0f;
    }

    protected abstract double getFlySpeed();
}

