/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import fossilsarcheology.Revival;
import fossilsarcheology.server.block.BlockAnalyzer;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.enums.EnumDinoBones;
import fossilsarcheology.server.enums.EnumPrehistoric;
import fossilsarcheology.server.handler.FossilAchievementHandler;
import fossilsarcheology.server.item.BirdEggItem;
import fossilsarcheology.server.item.DinoEggItem;
import fossilsarcheology.server.item.DinosaurBoneItem;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;

public class TileEntityAnalyzer
extends TileEntity
implements IInventory,
ISidedInventory {
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] slots_bottom = new int[]{9, 10, 11, 12};
    public int analyzerBurnTime = 0;
    public int currentItemBurnTime = 100;
    public int analyzerCookTime = 0;
    private String customName;
    private ItemStack[] analyzerItemStacks = new ItemStack[13];
    private int RawIndex = -1;
    private int SpaceIndex = -1;

    private static int getItemBurnTime(ItemStack var1) {
        return 100;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityAnalyzer.getItemBurnTime(par0ItemStack) > 0;
    }

    public int func_70302_i_() {
        return this.analyzerItemStacks.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.analyzerItemStacks[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.analyzerItemStacks[var1] != null) {
            if (this.analyzerItemStacks[var1].field_77994_a <= var2) {
                ItemStack var3 = this.analyzerItemStacks[var1];
                this.analyzerItemStacks[var1] = null;
                return var3;
            }
            ItemStack var3 = this.analyzerItemStacks[var1].func_77979_a(var2);
            if (this.analyzerItemStacks[var1].field_77994_a == 0) {
                this.analyzerItemStacks[var1] = null;
            }
            return var3;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.analyzerItemStacks[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "tile.analyzer.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setGuiDisplayName(String par1Str) {
        this.customName = par1Str;
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        NBTTagList var2 = var1.func_150295_c("Items", 10);
        this.analyzerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.analyzerItemStacks.length) continue;
            this.analyzerItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.analyzerBurnTime = var1.func_74765_d("BurnTime");
        this.analyzerCookTime = var1.func_74765_d("CookTime");
        this.currentItemBurnTime = 100;
        if (var1.func_74764_b("CustomName")) {
            this.customName = var1.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74777_a("BurnTime", (short)this.analyzerBurnTime);
        var1.func_74777_a("CookTime", (short)this.analyzerCookTime);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.analyzerItemStacks.length; ++var3) {
            if (this.analyzerItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.analyzerItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        if (this.func_145818_k_()) {
            var1.func_74778_a("CustomName", this.customName);
        }
        var1.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getAnalyzeProgressScaled(int var1) {
        return this.analyzerCookTime * var1 / 200;
    }

    public int getBurnTimeRemainingScaled(int var1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 100;
        }
        return this.analyzerBurnTime * var1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.analyzerBurnTime > 0;
    }

    public void func_145845_h() {
        for (int var7 = 0; var7 < this.field_145850_b.field_73010_i.size(); ++var7) {
            EntityPlayer P = (EntityPlayer)this.field_145850_b.field_73010_i.get(var7);
            if (!(Math.pow((double)this.field_145851_c - P.field_70165_t, 2.0) + Math.pow((double)this.field_145848_d - P.field_70163_u, 2.0) + Math.pow((double)this.field_145849_e - P.field_70161_v, 2.0) < 40.0)) continue;
            for (int slots = 12; slots > 8; --slots) {
                if (this.analyzerItemStacks[slots] == null || this.analyzerItemStacks[slots].func_77973_b() == null || this.analyzerItemStacks[slots].func_77973_b() != FAItemRegistry.INSTANCE.stoneboard) continue;
                P.func_71064_a((StatBase)FossilAchievementHandler.tablet, 1);
            }
        }
        boolean var1 = this.analyzerBurnTime > 0;
        boolean var2 = false;
        if (this.analyzerBurnTime > 0) {
            --this.analyzerBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.analyzerBurnTime == 0 && this.canSmelt()) {
                this.analyzerBurnTime = 100;
                this.currentItemBurnTime = 100;
                if (this.analyzerBurnTime > 0) {
                    var2 = true;
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.analyzerCookTime;
                if (this.analyzerCookTime == 200) {
                    this.analyzerCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.analyzerCookTime = 0;
            }
            if (var1 != this.analyzerBurnTime > 0) {
                var2 = true;
                BlockAnalyzer.updateFurnaceBlockState(this.analyzerBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        int var1;
        this.SpaceIndex = -1;
        this.RawIndex = -1;
        for (var1 = 0; var1 < 9; ++var1) {
            if (this.analyzerItemStacks[var1] == null) continue;
            Item var2 = this.analyzerItemStacks[var1].func_77973_b();
            if (!EnumPrehistoric.isFoodItem(this.analyzerItemStacks[var1].func_77973_b()) && !(var2 instanceof DinosaurBoneItem) && var2 != FAItemRegistry.INSTANCE.biofossil && var2 != FAItemRegistry.INSTANCE.tarfossil && var2 != FAItemRegistry.INSTANCE.tardrop && var2 != FAItemRegistry.INSTANCE.failuresaurusFlesh && var2 != FAItemRegistry.INSTANCE.relic && var2 != Items.field_151147_al && var2 != Items.field_151082_bd && var2 != Items.field_151110_aK && var2 != Items.field_151076_bf && var2 != Item.func_150898_a((Block)Blocks.field_150325_L) && var2 != FAItemRegistry.INSTANCE.icedMeat && var2 != Items.field_151116_aA && var2 != FAItemRegistry.INSTANCE.brokenSapling) continue;
            this.RawIndex = var1;
            break;
        }
        if (this.RawIndex == -1) {
            return false;
        }
        for (var1 = 12; var1 > 8; --var1) {
            if (this.analyzerItemStacks[var1] != null) continue;
            this.SpaceIndex = var1;
            break;
        }
        return this.SpaceIndex != -1 && this.RawIndex != -1;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = null;
            int rand = new Random().nextInt(100);
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() instanceof DinosaurBoneItem) {
                if (rand > -1 && rand <= 30) {
                    itemstack = new ItemStack(Items.field_151100_aR, 3, 15);
                }
                if (rand > 30 && rand <= 65) {
                    itemstack = new ItemStack(Items.field_151103_aS, 3);
                }
                if (rand > 65) {
                    itemstack = new ItemStack(EnumDinoBones.from((EnumDinoBones)EnumDinoBones.values()[this.analyzerItemStacks[this.RawIndex].func_77960_j()]).DNAItem, 1);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() instanceof DinoEggItem || this.analyzerItemStacks[this.RawIndex].func_77973_b() instanceof BirdEggItem) {
                if (!Revival.RELEASE_TYPE.enableDebugging()) {
                    if (rand > -1 && rand <= 50) {
                        itemstack = new ItemStack(Items.field_151100_aR, new Random().nextInt(2) + 1, 15);
                    }
                    if (rand > 50) {
                        itemstack = new ItemStack(EnumPrehistoric.getDNA(this.analyzerItemStacks[this.RawIndex].func_77973_b()));
                    }
                } else {
                    itemstack = new ItemStack(EnumPrehistoric.getRandomMezoic().DNAItem, 1);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.biofossil) {
                if (!Revival.RELEASE_TYPE.enableDebugging()) {
                    if (rand > -1 && rand <= 50) {
                        itemstack = new ItemStack(Items.field_151100_aR, 3, 15);
                    }
                    if (rand > 50 && rand <= 85) {
                        itemstack = new ItemStack((Block)Blocks.field_150354_m, 1 + new Random().nextInt(2));
                    }
                    if (rand > 85) {
                        itemstack = new ItemStack(EnumPrehistoric.getRandomMezoic().DNAItem, 1);
                    }
                } else {
                    itemstack = new ItemStack(EnumPrehistoric.getRandomMezoic().DNAItem, 1);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.tarfossil) {
                if (rand > -1 && rand <= 50) {
                    itemstack = new ItemStack(Items.field_151100_aR, 3, 15);
                }
                if (rand > 50 && rand <= 80) {
                    itemstack = new ItemStack(FABlockRegistry.INSTANCE.volcanicRock, 1);
                }
                if (rand > 80 && rand <= 75) {
                    itemstack = new ItemStack(Blocks.field_150343_Z, 1);
                }
                if (rand > 75) {
                    itemstack = new ItemStack(EnumPrehistoric.getRandomCenozoic().DNAItem, 1);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.tardrop) {
                if (rand >= 0 && rand <= 40) {
                    itemstack = new ItemStack(Items.field_151044_h, new Random().nextInt(2) + 1, new Random().nextInt(1));
                }
                if (rand > 40 && rand <= 85) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.tarfossil, 1);
                }
                if (rand > 85) {
                    itemstack = new ItemStack(FABlockRegistry.INSTANCE.volcanicRock, 1);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.brokenSapling) {
                if (rand > 0) {
                    itemstack = new ItemStack((Block)Blocks.field_150354_m, 1 + new Random().nextInt(1), 0);
                }
                if (rand > 35 && rand <= 65) {
                    itemstack = new ItemStack(Items.field_151044_h, 1, 0);
                }
                if (rand > 65 && rand <= 75) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.palaeSaplingFossil, 1, 0);
                }
                if (rand > 75 && rand <= 85) {
                    itemstack = new ItemStack(Items.field_151100_aR, 1, 2);
                }
                if (rand > 85) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.fossilSeed, 1, new Random().nextInt(14));
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                itemstack = new Random().nextInt(50) <= 30 ? new ItemStack(Items.field_151007_F, 4) : new ItemStack(EnumPrehistoric.Sheep.DNAItem, 1);
            }
            if (EnumPrehistoric.getDNA(this.analyzerItemStacks[this.RawIndex].func_77973_b()) != null) {
                itemstack = new ItemStack(EnumPrehistoric.getDNA(this.analyzerItemStacks[this.RawIndex].func_77973_b()), 1);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Items.field_151147_al) {
                itemstack = new ItemStack(EnumPrehistoric.Pig.DNAItem, 2);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Items.field_151082_bd) {
                itemstack = new ItemStack(EnumPrehistoric.Cow.DNAItem, 2);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.failuresaurusFlesh) {
                int randChoice = new Random().nextInt(3);
                itemstack = randChoice == 0 ? new ItemStack(Items.field_151078_bh, 1) : new ItemStack(EnumPrehistoric.getRandom().DNAItem, 1);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Items.field_151116_aA) {
                itemstack = new Random().nextInt(10) > 3 ? new ItemStack(EnumPrehistoric.Cow.DNAItem, 1) : new ItemStack(EnumPrehistoric.Horse.DNAItem, 1);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Items.field_151110_aK) {
                itemstack = new ItemStack(EnumPrehistoric.Chicken.DNAItem, 1);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Items.field_151076_bf) {
                itemstack = new ItemStack(EnumPrehistoric.Chicken.DNAItem, 1);
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.icedMeat) {
                if (rand >= 15) {
                    itemstack = new ItemStack(Items.field_151076_bf, 1);
                }
                if (rand >= 15 && rand < 30) {
                    itemstack = new ItemStack(Items.field_151076_bf, 1);
                }
                if (rand >= 30 && rand < 45) {
                    itemstack = new ItemStack(Items.field_151147_al, 1);
                }
                if (rand >= 45 && rand < 65) {
                    itemstack = new ItemStack(EnumPrehistoric.getRandomCenozoic().DNAItem);
                }
                if (rand >= 65 && rand < 85) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.tarfossil);
                }
                if (itemstack == null) {
                    itemstack = new ItemStack(Items.field_151082_bd);
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == FAItemRegistry.INSTANCE.relic) {
                if (rand <= 40) {
                    itemstack = new ItemStack(Blocks.field_150351_n, 1 + new Random().nextInt(2));
                }
                if (rand > 40 && rand <= 70) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.stoneboard, 1);
                }
                if (rand > 70 && rand <= 88) {
                    itemstack = new ItemStack(Items.field_151145_ak, 1 + new Random().nextInt(1));
                }
                if (rand > 88 && rand <= 92) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.potteryShards, 1);
                }
                if (rand > 92 && rand <= 96) {
                    itemstack = (double)new Random().nextFloat() < 0.7 ? new ItemStack(FABlockRegistry.INSTANCE.figurineBlock, 1, new Random().nextInt(5) + 10) : new ItemStack(FABlockRegistry.INSTANCE.figurineBlock, 1, new Random().nextInt(5) + 5);
                }
                if (rand > 96) {
                    itemstack = new ItemStack(FAItemRegistry.INSTANCE.brokenSword, 1);
                }
            }
            if (itemstack != null) {
                for (int slots = 9; slots < 13; ++slots) {
                    ItemStack stackInSlot = this.analyzerItemStacks[slots];
                    if (stackInSlot != null) {
                        if (!stackInSlot.func_77969_a(itemstack) || stackInSlot.field_77994_a + itemstack.field_77994_a >= 64) continue;
                        stackInSlot.field_77994_a += itemstack.field_77994_a;
                        if (this.analyzerItemStacks[this.RawIndex].field_77994_a > 1) {
                            --this.analyzerItemStacks[this.RawIndex].field_77994_a;
                            break;
                        }
                        this.analyzerItemStacks[this.RawIndex] = null;
                        break;
                    }
                    if (stackInSlot != null) continue;
                    this.analyzerItemStacks[slots] = itemstack;
                    if (this.analyzerItemStacks[this.RawIndex].field_77994_a > 1) {
                        --this.analyzerItemStacks[this.RawIndex].field_77994_a;
                        break;
                    }
                    this.analyzerItemStacks[this.RawIndex] = null;
                    break;
                }
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean isStackValidForSlot(int par1, ItemStack par2ItemStack) {
        return par1 <= 8 && (par1 >= 8 || TileEntityAnalyzer.isItemFuel(par2ItemStack));
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 != 2 && (par1 != 1 || TileEntityAnalyzer.isItemFuel(par2ItemStack));
    }

    public int[] func_94128_d(int par1) {
        return par1 == 1 ? slots_top : slots_bottom;
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack itemstack, int par3) {
        return par3 != 0 || par1 != 1;
    }

    public void func_70295_k_() {
        for (int var7 = 0; var7 < this.field_145850_b.field_73010_i.size(); ++var7) {
            EntityPlayer P = (EntityPlayer)this.field_145850_b.field_73010_i.get(var7);
            if (!(Math.pow((double)this.field_145851_c - P.field_70165_t, 2.0) + Math.pow((double)this.field_145848_d - P.field_70163_u, 2.0) + Math.pow((double)this.field_145849_e - P.field_70161_v, 2.0) < 40.0)) continue;
            for (int slots = 12; slots > 8; --slots) {
                if (this.analyzerItemStacks[slots] == null || this.analyzerItemStacks[slots].func_77973_b() == null || this.analyzerItemStacks[slots].func_77973_b() != FAItemRegistry.INSTANCE.stoneboard) continue;
                P.func_71064_a((StatBase)FossilAchievementHandler.tablet, 1);
            }
        }
    }

    public void func_70305_f() {
    }
}

