/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentLever;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;

public class GateToggleLatch
extends GateSimpleDigital {
    private boolean power = false;
    private boolean state = true;
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentLever l;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable();
        ((GateConnectionDigital)this.right()).enable();
        ((GateConnectionDigital)this.back()).enable().setOutputOnly();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.25, true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 7274677, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.l = new GateComponentLever(this, 65280).setState(true);
        this.addComponent(this.l);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "toggle";
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if ((this.power != ((GateConnectionDigital)this.right()).getInput() || ((GateConnectionDigital)this.left()).getInput()) && !this.power) {
            this.state = !this.state;
            this.playTickSound();
        }
        this.power = ((GateConnectionDigital)this.right()).getInput() || ((GateConnectionDigital)this.left()).getInput();
        ((GateConnectionDigital)this.front()).setOutput(this.state);
        ((GateConnectionDigital)this.back()).setOutput(!this.state);
        this.t1.setState(!this.state);
        this.t2.setState(this.state);
        this.l.setState(this.state);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.state = tag.func_74767_n("state");
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition hit, ItemStack item) {
        if (super.onActivated(player, hit, item)) {
            return true;
        }
        if (!this.getWorld().field_72995_K) {
            this.state = !this.state;
            this.doLogic();
        }
        this.playTickSound();
        return true;
    }
}

