/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.gui.gate.GuiGateSingleCounter;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentPointer;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GateTimer
extends GateSimpleDigital
implements IGuiButtonSensitive {
    private int time = 40;
    private long start = -1L;
    private GateComponentPointer p;
    private GateComponentTorch t;
    private GateComponentWire w;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.left()).enable();
    }

    @Override
    public void initComponents() {
        this.p = new GateComponentPointer(this, 255, 0.4375, true);
        this.addComponent(this.p.setShouldSync(false).setState(true));
        this.t = new GateComponentTorch(this, 7274677, 0.1875, true);
        this.addComponent(this.t);
        this.w = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "timer";
    }

    @Override
    public void doLogic() {
        this.sendUpdatePacket();
    }

    @Override
    public void tick() {
        if (((GateConnectionDigital)this.back()).getInput() && !((GateConnectionDigital)this.front()).getOutput() || ((GateConnectionDigital)this.left()).getInput() && !((GateConnectionDigital)this.left()).getOutput() || ((GateConnectionDigital)this.right()).getInput() && !((GateConnectionDigital)this.right()).getOutput()) {
            this.start = -1L;
            this.p.setAngle(0.0);
            this.p.setIncrement(0.0);
            return;
        }
        if (!this.getWorld().field_72995_K) {
            ((GateConnectionDigital)this.front()).setOutput(false);
            ((GateConnectionDigital)this.left()).setOutput(false);
            ((GateConnectionDigital)this.right()).setOutput(false);
            this.t.setState(false);
            this.w.setPower((byte)-1);
            ((GateConnectionDigital)this.left()).notifyUpdateIfNeeded();
            ((GateConnectionDigital)this.right()).notifyUpdateIfNeeded();
        }
        long curTime = this.getWorld().func_82737_E();
        if (this.start != -1L && curTime != this.start && curTime - this.start >= (long)this.time) {
            while (curTime - this.start >= (long)this.time) {
                this.start += (long)this.time;
            }
            this.playTickSound();
            if (!this.getWorld().field_72995_K) {
                ((GateConnectionDigital)this.front()).setOutput(true);
                ((GateConnectionDigital)this.left()).setOutput(true);
                ((GateConnectionDigital)this.right()).setOutput(true);
                this.t.setState(true);
                this.w.setPower((byte)0);
                ((GateConnectionDigital)this.left()).notifyUpdateIfNeeded();
                ((GateConnectionDigital)this.right()).notifyUpdateIfNeeded();
            }
        }
        if (this.start == -1L) {
            this.start = curTime;
        }
        this.p.setAngle((double)(curTime - this.start) / (double)this.time);
        this.p.setIncrement(1.0 / (double)this.time);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74772_a("start", this.start);
        tag.func_74768_a("time", this.time);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.start = tag.func_74763_f("start");
        this.time = tag.func_74762_e("time");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.time);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.time = buffer.readInt();
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        this.time = value;
        this.start = 0L;
        this.sendUpdatePacket();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return new GuiGateSingleCounter(this){

            @Override
            protected int getCurrentAmount() {
                return GateTimer.this.time;
            }
        };
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        String t = "";
        int time = this.time * 50;
        if (time >= 1000) {
            String ms = "" + time % 1000;
            if (ms.length() > 1) {
                while (ms.length() < 3) {
                    ms = "0" + ms;
                }
            }
            t = time / 1000 + "." + ms + "s";
        } else {
            t = time + "ms";
        }
        info.add(I18n.func_135052_a((String)"gui.bluepower:timer.interval", (Object[])new Object[0]) + ": " + SpecialChars.WHITE + t);
    }
}

