/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part;

import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.PartPlacementFace;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCustomPlacement;
import uk.co.qmunity.lib.part.IPartFace;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class BPPartFace
extends BPPart
implements IPartFace,
IFace,
IPartCustomPlacement {
    private ForgeDirection face = ForgeDirection.UNKNOWN;

    @Override
    public ForgeDirection getFace() {
        return this.face;
    }

    public boolean canStay() {
        return this.getWorld().isSideSolid(this.getX() + this.getFace().offsetX, this.getY() + this.getFace().offsetY, this.getZ() + this.getFace().offsetZ, this.getFace().getOpposite());
    }

    public void setFace(ForgeDirection face) {
        this.face = face;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("face", this.face.ordinal());
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.face = ForgeDirection.getOrientation((int)tag.func_74762_e("face"));
    }

    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.face.ordinal());
    }

    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.face = ForgeDirection.getOrientation((int)buffer.readInt());
    }

    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        return new PartPlacementFace(face.getOpposite());
    }

    @Override
    public void onNeighborBlockChange() {
        if (this.getParent() == null || this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        if (!this.canStay()) {
            if (this.breakAndDrop(null, null)) {
                this.getParent().removePart((IPart)this);
            }
            return;
        }
        super.onNeighborBlockChange();
    }
}

