/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.network.INetworkItemEventListener;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.item.ItemIC2;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemDebug
extends ItemIC2
implements INetworkItemEventListener {
    private static String[] modes = new String[]{"Interfaces and Fields", "Tile Data"};
    private int mode = 1;

    public ItemDebug() {
        super(47);
        this.func_77627_a(false);
        this.func_77637_a(IC2.tabIC2);
        this.func_77655_b("itemDebug");
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                ++this.mode;
                if (this.mode >= modes.length) {
                    this.mode = 0;
                }
                IC2.network.get().initiateItemEvent(player, stack, this.mode, true);
                IC2.platform.messagePlayer(player, "Debug Item Mode: " + modes[this.mode]);
            }
            return false;
        }
        switch (this.mode) {
            case 0: {
                Block blockId = world.func_147439_a(x, y, z);
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                String plat = IC2.platform.isRendering() ? "client" : (IC2.platform.isSimulating() ? "sp" : "server");
                String message = blockId != Blocks.field_150350_a ? "[" + plat + "] id: " + blockId + " name: " + blockId.func_149739_a() + " te: " + tileEntity : "[" + plat + "] id: " + blockId + " name: null te: " + tileEntity;
                IC2.platform.messagePlayer(player, message);
                System.out.println(message);
                if (tileEntity != null) {
                    message = "[" + plat + "] interfaces:";
                    Class<?> c = tileEntity.getClass();
                    do {
                        for (Class<?> i : c.getInterfaces()) {
                            message = message + " " + i.getName();
                        }
                    } while ((c = c.getSuperclass()) != null);
                    IC2.platform.messagePlayer(player, message);
                    System.out.println(message);
                }
                if (blockId != null) {
                    System.out.println("block fields:");
                    ItemDebug.dumpObjectFields(blockId);
                }
                if (tileEntity == null) break;
                System.out.println("tile entity fields:");
                ItemDebug.dumpObjectFields(tileEntity);
                break;
            }
            case 1: {
                if (!IC2.platform.isSimulating()) {
                    return false;
                }
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (tileEntity instanceof TileEntityBlock) {
                    TileEntityBlock te = (TileEntityBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "Block: Active=" + te.getActive() + " Facing=" + te.getFacing());
                }
                if (tileEntity instanceof TileEntityBaseGenerator) {
                    TileEntityBaseGenerator te2 = (TileEntityBaseGenerator)tileEntity;
                    IC2.platform.messagePlayer(player, "BaseGen: Fuel=" + te2.fuel + " Storage=" + te2.storage);
                }
                if (tileEntity instanceof TileEntityElecMachine) {
                    TileEntityElecMachine te3 = (TileEntityElecMachine)tileEntity;
                    IC2.platform.messagePlayer(player, "ElecMachine: Energy=" + te3.energy);
                }
                if (tileEntity instanceof IEnergyStorage) {
                    IEnergyStorage te4 = (IEnergyStorage)tileEntity;
                    IC2.platform.messagePlayer(player, "EnergyStorage: Stored=" + te4.getStored());
                }
                if (tileEntity instanceof IReactor) {
                    IReactor te5 = (IReactor)tileEntity;
                    IC2.platform.messagePlayer(player, "Reactor: Heat=" + te5.getHeat() + " MaxHeat=" + te5.getMaxHeat() + " HEM=" + te5.getHeatEffectModifier() + " Output=" + te5.getReactorEnergyOutput());
                }
                if (tileEntity instanceof IPersonalBlock) {
                    IPersonalBlock te6 = (IPersonalBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "PersonalBlock: CanAccess=" + te6.canAccess(player));
                }
                if (!(tileEntity instanceof TileEntityCrop)) break;
                TileEntityCrop te7 = (TileEntityCrop)tileEntity;
                IC2.platform.messagePlayer(player, "PersonalBlock: Crop=" + te7.getID() + " Size=" + te7.getSize() + " Growth=" + te7.getGrowth() + " Gain=" + te7.getGain() + " Resistance=" + te7.getResistance() + " Nutrients=" + te7.getNutrientStorage() + " Water=" + te7.getHydrationStorage() + " GrowthPoints=" + te7.growthPoints);
                break;
            }
        }
        return true;
    }

    private static void dumpObjectFields(Object o) {
        Class<?> fieldDeclaringClass = o.getClass();
        do {
            Field[] arr$;
            Field[] fields = arr$ = fieldDeclaringClass.getDeclaredFields();
            for (Field field : arr$) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: " + field.get(o));
                }
                catch (IllegalAccessException e) {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: <can't access>");
                }
                field.setAccessible(accessible);
            }
        } while ((fieldDeclaringClass = fieldDeclaringClass.getSuperclass()) != null);
    }

    @Override
    public void onNetworkEvent(ItemStack metaData, EntityPlayer player, int event) {
        this.mode = event;
    }
}

