/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.armor.ItemArmorUtility;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemArmorJetpack
extends ItemArmorUtility {
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;

    public ItemArmorJetpack(int spriteIndex, int armorrendering) {
        super(spriteIndex, armorrendering, 1);
        this.func_77656_e(18002);
    }

    public int getCharge(ItemStack itemStack) {
        int ret = (int)(this.getMaxCharge(itemStack) - (double)itemStack.func_77960_j() - 1.0);
        return ret > 0 ? ret : 0;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return itemStack.func_77958_k() - 2;
    }

    public void use(ItemStack itemStack, int amount) {
        int newCharge = this.getCharge(itemStack) - amount;
        if (newCharge < 0) {
            newCharge = 0;
        }
        itemStack.func_77964_b(1 + itemStack.func_77958_k() - newCharge);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        int maxFlightHeight;
        double y;
        float retruster;
        float forwardpower;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0) {
            return false;
        }
        boolean electric = this.isElectricJetpack();
        float power = this.getPower();
        float dropPercentage = this.getDropPercentage();
        if ((double)this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * ((double)this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player) && (forwardpower = power * (retruster = this.getThruster(hoverMode)) * 2.0f) > 0.0f) {
            player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
        }
        if ((y = player.field_70163_u) > (double)((maxFlightHeight = this.getMaxHeight(IC2.getWorldHeight(player.field_70170_p))) - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power *= (float)(((double)maxFlightHeight - y) / 25.0);
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.1f;
            if (electric && IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        this.use(jetpack, this.getFuelCost(hoverMode));
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    private boolean chargeRocketMode(EntityPlayer player) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0) {
            return false;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(jetpack);
        int chargedEnergy = nbtData.func_74762_e("UsedEnergy");
        if (chargedEnergy > this.getMaxRocketCharge()) {
            return false;
        }
        int fuelCost = this.getFuelCost(false) * 5;
        int used = Math.min(fuelCost, this.getCharge(jetpack));
        this.use(jetpack, fuelCost);
        nbtData.func_74768_a("UsedEnergy", chargedEnergy += used);
        return true;
    }

    private void checkRocketCharge(ItemStack jetpack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(jetpack);
        if (nbt.func_74764_b("UsedEnergy")) {
            nbt.func_82580_o("UsedEnergy");
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        boolean rocketMode = nbtData.func_74767_n("RocketMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        short rocketDelay = nbtData.func_74765_d("RocketDelay");
        boolean jetpackUsed = false;
        if (rocketMode && !this.canDoRocketMode()) {
            nbtData.func_74757_a("RocketMode", false);
        }
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeOn.name"));
                    if (rocketMode) {
                        rocketMode = false;
                        nbtData.func_74757_a("RocketMode", rocketMode);
                        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeForcedOff.name"));
                        this.checkRocketCharge(itemStack);
                    }
                } else {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeOff.name"));
                }
            }
        }
        if (IC2.keyboard.isModeSwitchKeyDown(player) && IC2.keyboard.isBoostKeyDown(player) && this.canDoRocketMode() && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = rocketMode = !rocketMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("RocketMode", rocketMode);
                if (rocketMode) {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackRocketModeOn.name"));
                    if (hoverMode) {
                        hoverMode = false;
                        nbtData.func_74757_a("hoverMode", hoverMode);
                        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeForcedOff.name"));
                    }
                } else {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackRocketModeOff.name"));
                    this.checkRocketCharge(itemStack);
                }
            }
        }
        if (rocketMode && IC2.keyboard.isBoostKeyDown(player) && rocketDelay <= 0) {
            jetpackUsed = this.chargeRocketMode(player);
        }
        if (IC2.keyboard.isAltKeyDown(player) && rocketMode && rocketDelay <= 0) {
            rocketDelay = (short)this.releaseRocket(player);
            nbtData.func_74757_a("RocketMode", false);
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (IC2.keyboard.isJumpKeyDown(player) && !rocketMode && rocketDelay <= 0 || hoverMode && player.field_70181_x < (double)-0.35f) {
            jetpackUsed = this.useJetpack(player, hoverMode);
        }
        if (IC2.platform.isSimulating()) {
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
            }
            if (rocketDelay > 0) {
                rocketDelay = (short)(rocketDelay - 1);
                nbtData.func_74777_a("RocketDelay", rocketDelay);
            }
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
    }

    public int releaseRocket(EntityPlayer player) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(jetpack);
        int charge = nbt.func_74762_e("UsedEnergy");
        if (charge <= 0) {
            return 0;
        }
        nbt.func_74768_a("UsedEnergy", 0);
        this.use(jetpack, 50);
        int charges = charge / this.getFuelCost(false);
        float speed = this.getPower() * (float)(charges /= 50);
        player.field_70181_x += (double)Math.min(speed /= 4.0f, 10.0f);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return (int)(speed * 10.0f);
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        itemList.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    public String getTextureName() {
        return "jetpack_fuel";
    }

    public float getDropPercentage() {
        return 0.5f;
    }

    public float getPower() {
        return 1.0f;
    }

    public boolean isElectricJetpack() {
        return false;
    }

    public int getFuelCost(boolean hoverMode) {
        return hoverMode ? 6 : 9;
    }

    public int getMaxHeight(int worldHight) {
        return worldHight;
    }

    public float getThruster(boolean hoverMode) {
        return hoverMode ? 0.5f : 0.15f;
    }

    public boolean canDoRocketMode() {
        return false;
    }

    public int getMaxRocketCharge() {
        return 0;
    }

    static {
        lastJetpackUsed = false;
    }
}

