/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityWaterGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public int ticker = randomizer.nextInt(this.tickRate());
    public int water = 0;
    public int microStorage = 0;
    public int maxWater = 2000;

    public TileEntityWaterGenerator() {
        super(2, 2, 2);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateWaterCount();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxWater;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] != null && this.maxWater - this.fuel >= 500) {
            if (this.inventory[1].func_77973_b() == Items.field_151131_as) {
                this.production = 1;
                this.fuel += 500;
                this.inventory[1].func_150996_a(Items.field_151133_ar);
                return true;
            }
            if (this.inventory[1].func_77973_b() == Ic2Items.waterCell.func_77973_b()) {
                this.production = 2;
                this.fuel += 500;
                ItemStack itemStack = this.inventory[1];
                --itemStack.field_77994_a;
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
                return true;
            }
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[1]);
            if (liquid != null && liquid.getFluidID() == FluidRegistry.WATER.getID()) {
                this.fuel += 500;
                if (this.inventory[1].func_77973_b().func_77634_r()) {
                    this.production = 1;
                    this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                } else {
                    this.production = 2;
                    ItemStack itemStack2 = this.inventory[1];
                    --itemStack2.field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                }
                return true;
            }
        } else if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage -= this.production * 100;
            if (this.production > 0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxWater;
    }

    public void flowPower() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateWaterCount();
        }
        this.water = this.water * IC2.energyGeneratorWater / 100;
        if (this.water > 0) {
            this.microStorage += this.water;
        }
    }

    public void updateWaterCount() {
        int count = 0;
        for (int x = this.field_145851_c - 1; x < this.field_145851_c + 2; ++x) {
            for (int y = this.field_145848_d - 1; y < this.field_145848_d + 2; ++y) {
                for (int z = this.field_145849_e - 1; z < this.field_145849_e + 2; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150358_i && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150355_j) continue;
                    ++count;
                }
            }
        }
        this.water = count;
    }

    @Override
    public String func_145825_b() {
        return "Water Mill";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiWaterGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WatermillLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterGenerator(entityPlayer, this);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    @Override
    public int getMaxEnergyAmount() {
        return 2;
    }
}

