/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            if (!this.func_145837_r() && this.field_145850_b != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

                        @Override
                        public void tickCallback(World world) {
                            TileEntityBlock.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warn(this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") was not added, isInvalid=" + this.func_145837_r() + ", worldObj=" + this.field_145850_b);
            }
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        if (!IC2.platform.isSimulating()) {
            IC2.network.get().requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        short short1;
        super.func_145839_a(nbttagcompound);
        this.facing = short1 = nbttagcompound.func_74765_d("facing");
        this.prevFacing = short1;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            IC2.network.get().updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (block != null) {
                int side;
                boolean newActive = this.active;
                short newFacing = this.facing;
                this.active = this.prevActive;
                this.facing = this.prevFacing;
                IIcon[] textureIndex = new IIcon[6];
                for (side = 0; side < 6; ++side) {
                    textureIndex[side] = IC2.platform.getBlockTexture(block, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
                }
                this.active = newActive;
                this.facing = newFacing;
                for (side = 0; side < 6; ++side) {
                    IIcon newTextureIndex = IC2.platform.getBlockTexture(block, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
                    if (textureIndex[side] == newTextureIndex) continue;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
            } else {
                System.out.println("[IC2] Invalid TE at " + this.field_145851_c + "/" + this.field_145848_d + "/" + this.field_145849_e + ", no corresponding block");
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            IC2.network.get().updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public void onBlockBreak(Block a, int b) {
    }

    public boolean hasTileMeta() {
        return false;
    }

    public int getTileMeta() {
        return 0;
    }
}

