/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.AudioSourceClient;
import ic2.core.audio.PositionSpec;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class AudioManagerClient
extends AudioManager
implements IResourceManagerReloadListener {
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private int streamingSourceCount = 4;
    private boolean lateInitDone = false;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    private float blockMasterVolume = 1.0f;
    private float currentItemMasterVolume = 1.0f;
    private float currentBackpackMasterVolume = 1.0f;
    private int ticker = 0;
    private int nextId = 0;
    public boolean markForRemoving = false;
    private Map<Object, List<AudioSource>> objectToAudioSourceMap = new HashMap<Object, List<AudioSource>>();

    public AudioManagerClient() {
        this.defaultVolume = 1.2f;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @Override
    public void initialize(Configuration config) {
        if (config != null) {
            Property prop = config.get("general", "soundsEnabled", this.enabled);
            prop.comment = "Enable sounds";
            this.enabled = Boolean.parseBoolean(prop.getString());
            prop = config.get("general", "soundSourceLimit", this.maxSourceCount);
            prop.comment = "Maximum number of audio sources, only change if you know what you're doing";
            this.maxSourceCount = Integer.parseInt(prop.getString());
            prop = config.get("general", "Master Sound Volume", 0.5);
            prop.comment = "Master Volume that you can change ingame. Please do not change it. If you really want to then do a number between 0-1";
            this.masterVolume = Float.parseFloat(prop.getString());
            prop = config.get("general", "Tile Sound Volume", 1.0);
            prop.comment = "Master Volume for all Machines from IC2. Please do not change it. If you really want to then do a number between 0-1";
            this.blockMasterVolume = Float.parseFloat(prop.getString());
            prop = config.get("general", "Equippet Item Sound Volume", 1.0);
            prop.comment = "Master Volume for all Items that play Sounds in your Hand from IC2. Please do not change it. If you really want to then do a number between 0-1";
            this.currentItemMasterVolume = Float.parseFloat(prop.getString());
            prop = config.get("general", "Backpack Sound Volume", 1.0);
            prop.comment = "Master Volume for all Backpack Items that play Sounds from IC2. Please do not change it. If you really want to then do a number between 0-1";
            this.currentBackpackMasterVolume = Float.parseFloat(prop.getString());
            if (!this.enabled) {
                this.masterVolume = 0.0f;
            }
            config.save();
        }
        if (this.maxSourceCount <= 6) {
            IC2.log.info("Audio source limit too low to enable IC2 sounds.");
            this.enabled = false;
            this.masterVolume = 0.0f;
        }
        if (!this.enabled) {
            IC2.log.info("Sounds disabled.");
            return;
        }
        if (this.maxSourceCount < 6) {
            this.enabled = false;
            this.masterVolume = 0.0f;
            return;
        }
        IC2.log.info("Using " + this.maxSourceCount + " audio sources.");
        SoundSystemConfig.setNumberStreamingChannels((int)this.streamingSourceCount);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - this.streamingSourceCount));
    }

    public void updateSound(float f) {
        this.masterVolume = f;
        if (this.maxSourceCount <= 6) {
            this.masterVolume = 0.0f;
        }
        IC2.config.get("general", "Master Sound Volume", 0.5).set((double)this.masterVolume);
        IC2.config.save();
        if (this.masterVolume <= 0.0f) {
            this.enabled = false;
        } else if (this.masterVolume > 0.0f && this.maxSourceCount > 6) {
            this.enabled = true;
        }
    }

    public void updateSoundType(float f, PositionSpec type) {
        switch (type) {
            case Backpack: {
                this.currentBackpackMasterVolume = f;
                IC2.config.get("general", "Backpack Sound Volume", 1.0).set((double)f);
                IC2.config.save();
                break;
            }
            case Center: {
                this.blockMasterVolume = f;
                IC2.config.get("general", "Tile Sound Volume", 1.0).set((double)f);
                IC2.config.save();
                break;
            }
            case Hand: {
                this.currentItemMasterVolume = f;
                IC2.config.get("gerneal", "Equippet Item Sound Volume", 1.0).set((double)f);
                IC2.config.save();
            }
        }
    }

    @Override
    public void onTick() {
        if (!this.enabled || this.soundSystem == null) {
            return;
        }
        EntityPlayer player = IC2.platform.getPlayerInstance();
        if (player == null || Minecraft.func_71410_x().func_147113_T() && this.markForRemoving) {
            Vector<Object> audioSourceCarriers = new Vector<Object>(this.objectToAudioSourceMap.keySet());
            for (Object e : audioSourceCarriers) {
                this.removeSources(e);
            }
            this.markForRemoving = false;
        } else {
            for (Object obj : new HashSet<Object>(this.objectToAudioSourceMap.keySet())) {
                if (obj == null) {
                    this.objectToAudioSourceMap.remove(obj);
                } else if (obj instanceof TileEntity) {
                    TileEntity tileEntity = (TileEntity)obj;
                    if (tileEntity.func_145831_w().field_73011_w.field_76574_g != player.field_70170_p.field_73011_w.field_76574_g) {
                        this.objectToAudioSourceMap.remove(obj);
                    }
                } else if (obj instanceof Entity) {
                    Entity entity = (Entity)obj;
                    if (entity.field_70170_p.field_73011_w.field_76574_g != player.field_70170_p.field_73011_w.field_76574_g) {
                        this.objectToAudioSourceMap.remove(obj);
                    }
                } else if (obj instanceof AudioPosition) {
                    AudioPosition audioPosition = (AudioPosition)obj;
                    if (audioPosition.world.field_73011_w.field_76574_g != player.field_70170_p.field_73011_w.field_76574_g) {
                        this.objectToAudioSourceMap.remove(obj);
                    }
                } else {
                    this.objectToAudioSourceMap.remove(obj);
                }
                this.removeMarked(obj);
            }
            PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
            for (List<AudioSource> list : this.objectToAudioSourceMap.values()) {
                try {
                    for (AudioSource audioSource : list) {
                        audioSource.updateVolume(player);
                        if (!(audioSource.getRealVolume() > 0.0f) || !audioSource.matchDimension(player)) continue;
                        validAudioSources.add(audioSource);
                    }
                }
                catch (Exception e) {
                    FMLLog.getLogger().info("Audio Interaction Problem which got catched from Speiger's Secuirtiy System.");
                }
            }
            int i = 0;
            while (!validAudioSources.isEmpty()) {
                if (i < this.maxSourceCount) {
                    ((AudioSource)validAudioSources.poll()).activate();
                } else {
                    ((AudioSource)validAudioSources.poll()).cull();
                }
                ++i;
            }
        }
    }

    @Override
    public AudioSource createSource(Object obj, String initialSoundFile) {
        return this.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, this.defaultVolume);
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        if (!this.enabled) {
            return null;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return null;
        }
        String sourceName = this.getSourceName(this.nextId);
        ++this.nextId;
        AudioSourceClient audioSource = new AudioSourceClient(this.soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, priorized, volume);
        if (!this.objectToAudioSourceMap.containsKey(obj)) {
            this.objectToAudioSourceMap.put(obj, new LinkedList());
        }
        this.objectToAudioSourceMap.get(obj).add(audioSource);
        return audioSource;
    }

    @Override
    public void removeSources(Object obj) {
        if (this.soundSystem == null) {
            return;
        }
        if (!this.objectToAudioSourceMap.containsKey(obj)) {
            return;
        }
        for (AudioSource audioSource : this.objectToAudioSourceMap.get(obj)) {
            audioSource.remove();
        }
        this.objectToAudioSourceMap.remove(obj);
    }

    public void removeMarked(Object obj) {
        if (this.soundSystem == null) {
            return;
        }
        if (!this.objectToAudioSourceMap.containsKey(obj)) {
            return;
        }
        ArrayList<AudioSource> source = new ArrayList<AudioSource>();
        for (AudioSource audioSource : this.objectToAudioSourceMap.get(obj)) {
            if (((AudioSourceClient)audioSource).marked) {
                audioSource.remove();
                continue;
            }
            source.add(audioSource);
        }
        this.objectToAudioSourceMap.remove(obj);
        if (source.isEmpty()) {
            return;
        }
        this.objectToAudioSourceMap.put(obj, source);
    }

    @Override
    public void playOnce(Object obj, String soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.defaultVolume);
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean priorized, float volume) {
        if (!this.enabled) {
            return;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return;
        }
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        if (position == null) {
            return;
        }
        URL url = AudioSource.class.getClassLoader().getResource("assets/ic2/sounds/" + soundFile);
        if (url == null) {
            IC2.log.warn("Invalid sound file: " + soundFile);
            return;
        }
        String sourceName = this.soundSystem.quickPlay(priorized, url, soundFile, false, position.x, position.y, position.z, 2, this.fadingDistance * Math.max(volume, 1.0f));
        this.soundSystem.setVolume(sourceName, this.masterVolume * Math.min(volume, 1.0f));
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    @Override
    public float getDefaultVolume() {
        return 1.2f;
    }

    @Override
    public float getVolumeForType(PositionSpec type) {
        switch (type) {
            case Backpack: {
                return this.currentBackpackMasterVolume;
            }
            case Center: {
                return this.blockMasterVolume;
            }
            case Hand: {
                return this.currentItemMasterVolume;
            }
        }
        return 0.0f;
    }

    private boolean testSourceCount(int n) {
        IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)n);
        try {
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() == 0) {
                AL10.alDeleteSources((IntBuffer)sourceBuffer);
                return true;
            }
        }
        catch (Exception e) {
            AL10.alGetError();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return false;
    }

    private void getSoundSystem() {
        try {
            this.soundSystem = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)((SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (int)5)), (int)4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSourceName(int id) {
        return "ic2_cls" + id;
    }

    public void func_110549_a(IResourceManager par1) {
        this.soundSystem = null;
    }
}

