/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.tile.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionIC2 {
    private Random ExplosionRNG = new Random();
    private World worldObj;
    private int mapHeight;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float power;
    public float explosionDropRate;
    public float explosionDamage;
    public DamageSource damageSource;
    public String igniter;
    public List<EntityLivingBase> entitiesInRange;
    public Map vecMap = new HashMap();
    public Map<ChunkPosition, Boolean> destroyedBlockPositions = new HashMap<ChunkPosition, Boolean>();
    private double dropPowerLimit = 8.0;
    private int secondaryRayCount = 5;
    private Explosion fakeExplosion;

    public ExplosionIC2(World world, Entity entity, double d, double d1, double d2, float power, float drop, float entitydamage, DamageSource damagesource) {
        this.worldObj = world;
        this.mapHeight = IC2.getWorldHeight(world);
        this.exploder = entity;
        this.power = power;
        this.explosionDropRate = drop;
        this.explosionDamage = entitydamage;
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.damageSource = damagesource;
        this.fakeExplosion = new Explosion(world, entity, d2, d1, d2, power);
        if (damagesource == null) {
            this.damageSource = DamageSource.func_94539_a((Explosion)this.fakeExplosion);
        }
    }

    public ExplosionIC2(World world, Entity entity, double d, double d1, double d2, float power, float drop, float entitydamage) {
        this(world, entity, d, d1, d2, power, drop, entitydamage, null);
    }

    public ExplosionIC2(World world, Entity entity, double d, double d1, double d2, float power, float drop, float entitydamage, DamageSource damagesource, String igniter) {
        this(world, entity, d, d1, d2, power, drop, entitydamage, damagesource);
        this.igniter = igniter;
    }

    public void doExplosion() {
        if (this.power <= 0.0f) {
            return;
        }
        double maxDistance = (double)this.power / 0.4;
        this.entitiesInRange = this.worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.explosionX - maxDistance), (double)(this.explosionY - maxDistance), (double)(this.explosionZ - maxDistance), (double)(this.explosionX + maxDistance), (double)(this.explosionY + maxDistance), (double)(this.explosionZ + maxDistance)));
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / maxDistance));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int i = 0; i < steps; ++i) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)i;
                this.shootRay(this.explosionX, this.explosionY, this.explosionZ, phi, theta, this.power, phi_n % 8 == 0 && i % 8 == 0);
            }
        }
        if (this.damageSource == IC2DamageSource.nuke) {
            for (EntityLivingBase entity : this.worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.explosionX - 100.0), (double)(this.explosionY - 100.0), (double)(this.explosionZ - 100.0), (double)(this.explosionX + 100.0), (double)(this.explosionY + 100.0), (double)(this.explosionZ + 100.0)))) {
                if (ItemArmorHazmat.hasCompleteHazmat(entity)) continue;
                double d = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ);
                int hungerLength = (int)(120.0 * (100.0 - d));
                int poisonLength = (int)(80.0 * (30.0 - d));
                if (hungerLength >= 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, hungerLength, 0));
                }
                if (poisonLength < 0) continue;
                entity.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, poisonLength, 0));
            }
        }
        IC2.network.get().initiateExplosionEffect(this.worldObj, this.explosionX, this.explosionY, this.explosionZ);
        HashMap blocksToDrop = new HashMap();
        for (Map.Entry<ChunkPosition, Boolean> entry : this.destroyedBlockPositions.entrySet()) {
            int x = entry.getKey().field_151329_a;
            int y = entry.getKey().field_151327_b;
            int z = entry.getKey().field_151328_c;
            Block blockId = this.worldObj.func_147439_a(x, y, z);
            if (blockId == null) continue;
            if (entry.getValue().booleanValue()) {
                double effectX = (float)x + this.worldObj.field_73012_v.nextFloat();
                double effectY = (float)y + this.worldObj.field_73012_v.nextFloat();
                double effectZ = (float)z + this.worldObj.field_73012_v.nextFloat();
                double d3 = effectX - this.explosionX;
                double d2 = effectY - this.explosionY;
                d3 = effectZ - this.explosionZ;
                double effectDistance = MathHelper.func_76133_a((double)(d3 * d3 + d2 * d2 + d3 * d3));
                d3 /= effectDistance;
                d2 /= effectDistance;
                d3 /= effectDistance;
                double d4 = 0.5 / (effectDistance / (double)this.power + 0.1);
                d3 *= (d4 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f));
                this.worldObj.func_72869_a("explode", (effectX + this.explosionX) / 2.0, (effectY + this.explosionY) / 2.0, (effectZ + this.explosionZ) / 2.0, d3 *= d4, d2 *= d4, d3);
                this.worldObj.func_72869_a("smoke", effectX, effectY, effectZ, d3, d2, d3);
                Block block = blockId;
                if (this.worldObj.field_73012_v.nextFloat() <= this.explosionDropRate) {
                    int meta = this.worldObj.func_72805_g(x, y, z);
                    for (ItemStack itemStack : block.getDrops(this.worldObj, x, y, z, meta, 0)) {
                        ItemWithMeta itemWithMeta;
                        Map map;
                        XZposition xZposition = new XZposition(x / 2, z / 2);
                        if (!blocksToDrop.containsKey(xZposition)) {
                            blocksToDrop.put(xZposition, new HashMap());
                        }
                        if (!(map = (Map)blocksToDrop.get(xZposition)).containsKey(itemWithMeta = new ItemWithMeta(itemStack.func_77973_b(), itemStack.func_77960_j()))) {
                            map.put(itemWithMeta, new DropData(itemStack.field_77994_a, y));
                            continue;
                        }
                        map.put(itemWithMeta, ((DropData)map.get(itemWithMeta)).add(itemStack.field_77994_a, y));
                    }
                }
            }
            this.worldObj.func_147468_f(x, y, z);
            blockId.func_149723_a(this.worldObj, x, y, z, this.fakeExplosion);
        }
        for (Map.Entry<Object, Boolean> entry : blocksToDrop.entrySet()) {
            XZposition xZposition2 = (XZposition)entry.getKey();
            for (Map.Entry entry3 : ((Map)((Object)entry.getValue())).entrySet()) {
                int stackSize;
                ItemWithMeta itemWithMeta2 = (ItemWithMeta)entry3.getKey();
                for (int count = ((DropData)entry3.getValue()).n; count > 0; count -= stackSize) {
                    stackSize = Math.min(count, 64);
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)((float)xZposition2.x + this.worldObj.field_73012_v.nextFloat()) * 2.0, (double)((DropData)entry3.getValue()).maxY + 0.5, (double)((float)xZposition2.z + this.worldObj.field_73012_v.nextFloat()) * 2.0, new ItemStack(itemWithMeta2.itemId, stackSize, itemWithMeta2.metaData));
                    entityitem.field_145804_b = 10;
                    this.worldObj.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power, boolean killEntities) {
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        do {
            Block blockId = this.worldObj.func_147439_a((int)x, (int)y, (int)z);
            double absorption = 0.5;
            if (blockId != null) {
                absorption += ((double)blockId.getExplosionResistance(this.exploder, this.worldObj, (int)x, (int)y, (int)z, this.explosionX, this.explosionY, this.explosionZ) + 4.0) * 0.3;
            }
            if (absorption > 1000.0 && !ExplosionWhitelist.isBlockWhitelisted(blockId)) {
                absorption = 0.5;
            } else {
                ChunkPosition position;
                if (absorption > power) break;
                if (blockId != null && (!this.destroyedBlockPositions.containsKey(position = new ChunkPosition((int)x, (int)y, (int)z)) || power > 8.0 && this.destroyedBlockPositions.get(position).booleanValue())) {
                    this.destroyedBlockPositions.put(position, power <= 8.0);
                }
            }
            if (killEntities) {
                Iterator<EntityLivingBase> it = this.entitiesInRange.iterator();
                while (it.hasNext()) {
                    EntityLivingBase entity = it.next();
                    if (!((entity.field_70165_t - x) * (entity.field_70165_t - x) + (entity.field_70163_u - y) * (entity.field_70163_u - y) + (entity.field_70161_v - z) * (entity.field_70161_v - z) <= 25.0)) continue;
                    double dx = entity.field_70165_t - this.explosionX;
                    double dy = entity.field_70163_u - this.explosionY;
                    double dz = entity.field_70161_v - this.explosionZ;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    double distanceFactor = power / 2.0 / (Math.pow(distance, 0.8) + 1.0);
                    entity.func_70097_a(this.damageSource, (float)((int)Math.pow(distanceFactor * 3.0, 2.0)));
                    if (this.damageSource == IC2DamageSource.nuke && entity instanceof EntityPlayer && this.igniter != null && ((EntityPlayer)entity).func_146103_bH().getName().equals(this.igniter) && entity.func_110143_aJ() <= 0.0f) {
                        IC2.achievements.issueAchievement((EntityPlayer)entity, "dieFromOwnNuke");
                    }
                    dz /= distance;
                    EntityLivingBase entityLivingBase = entity;
                    entityLivingBase.field_70159_w += (dx /= distance) * distanceFactor;
                    EntityLivingBase entityLivingBase2 = entity;
                    entityLivingBase2.field_70181_x += (dy /= distance) * distanceFactor;
                    EntityLivingBase entityLivingBase3 = entity;
                    entityLivingBase3.field_70179_y += dz * distanceFactor;
                    it.remove();
                }
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.ExplosionRNG.nextDouble() * 2.0 * Math.PI, this.ExplosionRNG.nextDouble() * Math.PI, absorption * 0.4, false);
                }
            }
            power -= absorption;
            x += deltaX;
            z += deltaZ;
        } while (!(y <= 0.0) && (y += deltaY) < (double)this.mapHeight);
    }

    static class XZposition {
        int x;
        int z;

        XZposition(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XZposition) {
                XZposition xZposition = (XZposition)obj;
                return xZposition.x == this.x && xZposition.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 31 ^ this.z;
        }
    }

    static class ItemWithMeta {
        Item itemId;
        int metaData;

        ItemWithMeta(Item itemId, int metaData) {
            this.itemId = itemId;
            this.metaData = metaData;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemWithMeta) {
                ItemWithMeta itemWithMeta = (ItemWithMeta)obj;
                return itemWithMeta.itemId == this.itemId && itemWithMeta.metaData == this.metaData;
            }
            return false;
        }

        public int hashCode() {
            return this.itemId.hashCode() * 31 ^ this.metaData;
        }
    }

    static class DropData {
        int n;
        int maxY;

        DropData(int n, int y) {
            this.n = n;
            this.maxY = y;
        }

        public DropData add(int n, int y) {
            this.n += n;
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }
    }
}

