/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.schematic;

import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.imp.transform.vector.Pos;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Schematic {
    private String schematicName;

    public Schematic() {
    }

    public Schematic(String name) {
        this.schematicName = name;
    }

    public String getName() {
        return this.schematicName;
    }

    public abstract HashMap<Pos, Pair<Block, Integer>> getStructure(ForgeDirection var1, int var2);

    public HashMap<Pos, Pair<Block, Integer>> getLine(Pos start, ForgeDirection dir, Block block, int meta, int length) {
        HashMap<Pos, Pair<Block, Integer>> returnMap = new HashMap<Pos, Pair<Block, Integer>>();
        for (int i = 0; i < length; ++i) {
            returnMap.put((Pos)((Pos)new Pos(dir).multiply(i)).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
        }
        return returnMap;
    }

    public HashMap<Pos, Pair<Block, Integer>> getBox(Pos center, Block block, int meta, int size) {
        return this.getBox(center, block, meta, size, size);
    }

    public HashMap<Pos, Pair<Block, Integer>> getBox(Pos center, Block block, int meta, int sizeX, int sizeZ) {
        HashMap<Pos, Pair<Block, Integer>> returnMap = new HashMap<Pos, Pair<Block, Integer>>();
        Pos start = (Pos)new Pos(-sizeX, 0.0, -sizeZ).add(center);
        if (sizeX != sizeZ) {
            for (int x = 0; x <= sizeX * 2; ++x) {
                returnMap.put((Pos)new Pos(x, 0.0, 0.0).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
                returnMap.put((Pos)new Pos(x, 0.0, sizeZ * 2).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
            }
            for (int z = 0; z <= sizeZ * 2; ++z) {
                returnMap.put((Pos)new Pos(0.0, 0.0, z).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
                returnMap.put((Pos)new Pos(sizeX * 2, 0.0, z).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
            }
        } else {
            for (int s = 0; s <= sizeX * 2; ++s) {
                returnMap.put((Pos)new Pos(s, 0.0, 0.0).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
                returnMap.put((Pos)new Pos(s, 0.0, sizeZ * 2).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
                returnMap.put((Pos)new Pos(0.0, 0.0, s).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
                returnMap.put((Pos)new Pos(sizeZ * 2, 0.0, s).add(start), (Pair<Block, Integer>)new Pair((Object)block, (Object)meta));
            }
        }
        return returnMap;
    }
}

