/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.data.s;

import com.builtbroken.mc.lib.world.map.data.ChunkData;
import com.builtbroken.mc.lib.world.map.data.s.ChunkSectionShort;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ChunkDataShort
extends ChunkData {
    public final ChunkSectionShort[] sections = new ChunkSectionShort[16];

    public ChunkDataShort(int x, int z) {
        super(x, z);
    }

    public short getValue(int x, int y, int z) {
        int s = y / 16;
        if (this.sections[s] == null) {
            this.sections[s] = new ChunkSectionShort();
        }
        return this.sections[s].getValue(x, y & 0xF, z);
    }

    public short setValue(int x, int y, int z, int value) {
        return this.setValue(x, y, z, (short)value);
    }

    public short setValue(int x, int y, int z, short value) {
        int s = y / 16;
        if (this.sections[s] == null) {
            this.sections[s] = new ChunkSectionShort();
        }
        short prev = this.sections[s].getValue(x, y & 0xF, z);
        this.sections[s].setValue(x, y & 0xF, z, value);
        return prev;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.clear();
        NBTTagList list = nbt.func_150295_c("sections", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int section = tag.func_74762_e("section_id");
            this.sections[section] = new ChunkSectionShort();
            this.sections[section].load(nbt);
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.sections[i].save(nbt);
            tag.func_74774_a("section_id", (byte)i);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("sections", (NBTBase)list);
        return nbt;
    }

    @Override
    public Object readBytes(ByteBuf buf) {
        this.load(ByteBufUtils.readTag((ByteBuf)buf));
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.save(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        return buf;
    }

    public void clear() {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = null;
        }
    }
}

