/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.render.fx;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.rotation.Quaternion;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.RenderUtility;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FXElectricBolt
extends EntityFX {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voltzengine", "textures/fadedSphere.png");
    public float complexity;
    public double length;
    public int segmentCount;
    private float boltWidth = 0.05f;
    private Pos start;
    private Pos end;
    private ArrayList<BoltSegment> segments = new ArrayList();
    private HashMap<Integer, Integer> splitparents = new HashMap();
    private int maxSplitID = 0;
    private Random rand;
    private boolean isCalculated;

    public FXElectricBolt(World world, IPos3D startVec, IPos3D targetVec, long seed) {
        super(world, startVec.x(), startVec.y(), startVec.z(), 0.0, 0.0, 0.0);
        this.rand = seed == 0L ? new Random() : new Random(seed);
        this.start = new Pos(startVec);
        this.end = new Pos(targetVec);
        this.field_70546_d = 3 + this.rand.nextInt(3) - 1;
        this.field_70552_h = 0.55f + this.rand.nextFloat() * 0.1f;
        this.field_70553_i = 0.7f + this.rand.nextFloat() * 0.1f;
        this.field_70551_j = 1.0f;
        this.segmentCount = 1;
        this.length = this.start.distance(this.end);
        this.field_70547_e = 3 + this.rand.nextInt(3) - 1;
        this.complexity = 2.0f;
        this.segments.add(new BoltSegment(this.start, this.end));
        this.recalculateDifferences();
        this.split(2, this.length * (double)this.complexity / 8.0, 0.7f, 0.1f, 45.0f);
        this.split(2, this.length * (double)this.complexity / 12.0, 0.5f, 0.1f, 50.0f);
        this.split(2, this.length * (double)this.complexity / 17.0, 0.5f, 0.1f, 55.0f);
        this.split(2, this.length * (double)this.complexity / 23.0, 0.5f, 0.1f, 60.0f);
        this.split(2, this.length * (double)this.complexity / 30.0, 0.0f, 0.0f, 0.0f);
        this.split(2, this.length * (double)this.complexity / 34.0, 0.0f, 0.0f, 0.0f);
        this.split(2, this.length * (double)this.complexity / 40.0, 0.0f, 0.0f, 0.0f);
        this.finalizeBolt();
    }

    private static Pos getRelativeViewVector(Pos pos) {
        EntityClientPlayerMP renderentity = Minecraft.func_71410_x().field_71439_g;
        return new Pos((double)((float)renderentity.field_70165_t) - pos.x(), (double)((float)renderentity.field_70163_u) - pos.y(), (double)((float)renderentity.field_70161_v) - pos.z());
    }

    public FXElectricBolt setMultiplier(float m) {
        this.complexity = m;
        return this;
    }

    public FXElectricBolt setWidth(float m) {
        this.boltWidth = m;
        return this;
    }

    public FXElectricBolt setColor(float r, float g, float b) {
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        return this;
    }

    public void split(int splitAmount, double offset, float splitChance, float splitLength, float splitAngle) {
        if (!this.isCalculated) {
            ArrayList<BoltSegment> oldSegments = this.segments;
            this.segments = new ArrayList();
            BoltSegment prev = null;
            for (BoltSegment segment : oldSegments) {
                int i;
                prev = segment.prevSegment;
                Pos subSegment = (Pos)segment.difference.multiply(1.0f / (float)splitAmount);
                BoltPoint[] newPoints = new BoltPoint[splitAmount + 1];
                Pos startPoint = segment.startBolt.point;
                newPoints[0] = segment.startBolt;
                newPoints[splitAmount] = segment.endBolt;
                for (i = 1; i < splitAmount; ++i) {
                    Pos offsetVec = (Pos)new Pos(((Pos)segment.difference.perpendicular()).transform(new Quaternion(this.rand.nextFloat() * 360.0f, segment.difference))).multiply((double)(this.rand.nextFloat() - 0.5f) * offset);
                    Pos basepoint = (Pos)((Pos)startPoint.clone()).add((IPos3D)((Pos)subSegment.clone()).multiply(i));
                    newPoints[i] = new BoltPoint(basepoint, offsetVec);
                }
                for (i = 0; i < splitAmount; ++i) {
                    BoltSegment next = new BoltSegment(newPoints[i], newPoints[i + 1], segment.weight, segment.segmentID * splitAmount + i, segment.splitID);
                    next.prevSegment = prev;
                    if (prev != null) {
                        prev.nextSegment = next;
                    }
                    if (i != 0 && this.rand.nextFloat() < splitChance) {
                        Pos splitrot = new Pos(((Pos)next.difference.xCross()).transform(new Quaternion(this.rand.nextFloat() * 360.0f, next.difference)));
                        Pos diff = (Pos)new Pos(((Pos)next.difference.clone()).transform(new Quaternion((this.rand.nextFloat() * 0.66f + 0.33f) * splitAngle, splitrot))).multiply(splitLength);
                        ++this.maxSplitID;
                        this.splitparents.put(this.maxSplitID, next.splitID);
                        BoltSegment split = new BoltSegment(newPoints[i], new BoltPoint(newPoints[i + 1].basePoint, (Pos)((Pos)newPoints[i + 1].offSet.clone()).add(diff)), segment.weight / 2.0f, next.segmentID, this.maxSplitID);
                        split.prevSegment = prev;
                        this.segments.add(split);
                    }
                    prev = next;
                    this.segments.add(next);
                }
                if (segment.nextSegment == null) continue;
                segment.nextSegment.prevSegment = prev;
            }
            this.segmentCount *= splitAmount;
        }
    }

    public void finalizeBolt() {
        if (!this.isCalculated) {
            this.isCalculated = true;
            this.recalculateDifferences();
            Collections.sort(this.segments, new Comparator(){

                public int compare(BoltSegment o1, BoltSegment o2) {
                    return Float.compare(o2.weight, o1.weight);
                }

                public int compare(Object obj, Object obj1) {
                    return this.compare((BoltSegment)obj, (BoltSegment)obj1);
                }
            });
        }
    }

    private void recalculateDifferences() {
        HashMap<Integer, Integer> lastActiveSegment = new HashMap<Integer, Integer>();
        Collections.sort(this.segments, new Comparator(){

            public int compare(BoltSegment o1, BoltSegment o2) {
                int comp = Integer.valueOf(o1.splitID).compareTo(o2.splitID);
                if (comp == 0) {
                    return Integer.valueOf(o1.segmentID).compareTo(o2.segmentID);
                }
                return comp;
            }

            public int compare(Object obj, Object obj1) {
                return this.compare((BoltSegment)obj, (BoltSegment)obj1);
            }
        });
        int lastSplitCalc = 0;
        int lastActiveSeg = 0;
        for (BoltSegment segment : this.segments) {
            if (segment == null) continue;
            if (segment.splitID > lastSplitCalc) {
                lastActiveSegment.put(lastSplitCalc, lastActiveSeg);
                lastSplitCalc = segment.splitID;
                lastActiveSeg = (Integer)lastActiveSegment.get(this.splitparents.get(segment.splitID));
            }
            lastActiveSeg = segment.segmentID;
        }
        lastActiveSegment.put(lastSplitCalc, lastActiveSeg);
        lastSplitCalc = 0;
        lastActiveSeg = (Integer)lastActiveSegment.get(0);
        Iterator<BoltSegment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            BoltSegment segment = iterator.next();
            if (lastSplitCalc != segment.splitID) {
                lastSplitCalc = segment.splitID;
                lastActiveSeg = (Integer)lastActiveSegment.get(segment.splitID);
            }
            if (segment.segmentID > lastActiveSeg) {
                iterator.remove();
            }
            segment.calculateEndDifferences();
        }
    }

    private void renderBolt(Tessellator tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float cossinpitch, int pass) {
        Pos playerVector = new Pos(sinyaw * -cospitch, -cossinpitch / cosyaw, cosyaw * cospitch);
        float voltage = this.field_70546_d >= 0 ? (float)this.field_70546_d / (float)this.field_70547_e : 0.0f;
        float mainAlpha = 1.0f;
        mainAlpha = pass == 0 ? (1.0f - voltage) * 0.4f : 1.0f - voltage * 0.5f;
        int renderlength = (int)(((float)this.field_70546_d + partialframe + (float)((int)(this.length * 3.0))) / (float)((int)(this.length * 3.0)) * (float)this.segmentCount);
        for (BoltSegment renderSegment : this.segments) {
            float rz3;
            float ry3;
            float rx3;
            Pos roundend;
            if (renderSegment == null || renderSegment.segmentID > renderlength) continue;
            float width = (float)((double)this.boltWidth * (FXElectricBolt.getRelativeViewVector(renderSegment.startBolt.point).magnitude() / 5.0 + 1.0) * (double)(1.0f + renderSegment.weight) * 0.5);
            Pos diff1 = (Pos)((Pos)playerVector.cross(renderSegment.prevDiff)).multiply(width / renderSegment.sinPrev);
            Pos diff2 = (Pos)((Pos)playerVector.cross(renderSegment.nextDiff)).multiply(width / renderSegment.sinNext);
            Pos startvec = renderSegment.startBolt.point;
            Pos endvec = renderSegment.endBolt.point;
            float rx1 = (float)(startvec.x() - field_70556_an);
            float ry1 = (float)(startvec.y() - field_70554_ao);
            float rz1 = (float)(startvec.z() - field_70555_ap);
            float rx2 = (float)(endvec.x() - field_70556_an);
            float ry2 = (float)(endvec.y() - field_70554_ao);
            float rz2 = (float)(endvec.z() - field_70555_ap);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainAlpha * renderSegment.weight);
            tessellator.func_78374_a((double)rx2 - diff2.x(), (double)ry2 - diff2.y(), (double)rz2 - diff2.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx1 - diff1.x(), (double)ry1 - diff1.y(), (double)rz1 - diff1.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx1 + diff1.x(), (double)ry1 + diff1.y(), (double)rz1 + diff1.z(), 0.5, 1.0);
            tessellator.func_78374_a((double)rx2 + diff2.x(), (double)ry2 + diff2.y(), (double)rz2 + diff2.z(), 0.5, 1.0);
            if (renderSegment.nextSegment == null) {
                roundend = (Pos)((Pos)renderSegment.endBolt.point.clone()).add((IPos3D)((Pos)((Pos)renderSegment.difference.clone()).normalize()).multiply(width));
                rx3 = (float)(roundend.x() - field_70556_an);
                ry3 = (float)(roundend.y() - field_70554_ao);
                rz3 = (float)(roundend.z() - field_70555_ap);
                tessellator.func_78374_a((double)rx3 - diff2.x(), (double)ry3 - diff2.y(), (double)rz3 - diff2.z(), 0.0, 0.0);
                tessellator.func_78374_a((double)rx2 - diff2.x(), (double)ry2 - diff2.y(), (double)rz2 - diff2.z(), 0.5, 0.0);
                tessellator.func_78374_a((double)rx2 + diff2.x(), (double)ry2 + diff2.y(), (double)rz2 + diff2.z(), 0.5, 1.0);
                tessellator.func_78374_a((double)rx3 + diff2.x(), (double)ry3 + diff2.y(), (double)rz3 + diff2.z(), 0.0, 1.0);
            }
            if (renderSegment.prevSegment != null) continue;
            roundend = (Pos)((Pos)renderSegment.startBolt.point.clone()).subtract((IPos3D)((Pos)((Pos)renderSegment.difference.clone()).normalize()).multiply(width));
            rx3 = (float)(roundend.x() - field_70556_an);
            ry3 = (float)(roundend.y() - field_70554_ao);
            rz3 = (float)(roundend.z() - field_70555_ap);
            tessellator.func_78374_a((double)rx1 - diff1.x(), (double)ry1 - diff1.y(), (double)rz1 - diff1.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx3 - diff1.x(), (double)ry3 - diff1.y(), (double)rz3 - diff1.z(), 0.0, 0.0);
            tessellator.func_78374_a((double)rx3 + diff1.x(), (double)ry3 + diff1.y(), (double)rz3 + diff1.z(), 0.0, 1.0);
            tessellator.func_78374_a((double)rx1 + diff1.x(), (double)ry1 + diff1.y(), (double)rz1 + diff1.z(), 0.5, 1.0);
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialframe, float cosYaw, float cosPitch, float sinYaw, float sinSinPitch, float cosSinPitch) {
        EntityClientPlayerMP renderentity = Minecraft.func_71410_x().field_71439_g;
        int visibleDistance = 100;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance /= 2;
        }
        if (renderentity.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > (double)visibleDistance) {
            return;
        }
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78380_c(0xF000F0);
        this.renderBolt(tessellator, partialframe, cosYaw, cosPitch, sinYaw, cosSinPitch, 0);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78380_c(0xF000F0);
        this.renderBolt(tessellator, partialframe, cosYaw, cosPitch, sinYaw, cosSinPitch, 1);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(RenderUtility.PARTICLE_RESOURCE);
        tessellator.func_78382_b();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 2;
    }

    public class BoltSegment {
        public BoltPoint startBolt;
        public BoltPoint endBolt;
        public Pos difference;
        public BoltSegment prevSegment;
        public BoltSegment nextSegment;
        public Pos nextDiff;
        public Pos prevDiff;
        public float sinPrev;
        public float sinNext;
        public float weight;
        public int segmentID;
        public int splitID;

        public BoltSegment(BoltPoint startBolt, BoltPoint endBolt, float weight, int segmentID, int splitID) {
            this.startBolt = startBolt;
            this.endBolt = endBolt;
            this.weight = weight;
            this.segmentID = segmentID;
            this.splitID = splitID;
            this.calculateDifference();
        }

        public BoltSegment(Pos start, Pos end) {
            this(this$0.new BoltPoint(start, new Pos(0.0, 0.0, 0.0)), this$0.new BoltPoint(end, new Pos(0.0, 0.0, 0.0)), 1.0f, 0, 0);
        }

        public void calculateDifference() {
            this.difference = (Pos)((Pos)this.endBolt.point.clone()).subtract(this.startBolt.point);
        }

        public void calculateEndDifferences() {
            Pos thisdiffnorm;
            if (this.prevSegment != null) {
                Pos prevdiffnorm = (Pos)((Pos)this.prevSegment.difference.clone()).normalize();
                thisdiffnorm = (Pos)((Pos)this.difference.clone()).normalize();
                this.prevDiff = (Pos)((Pos)thisdiffnorm.add(prevdiffnorm)).normalize();
                this.sinPrev = (float)Math.sin(thisdiffnorm.anglePreNorm((IPos3D)prevdiffnorm.multiply(-1.0)) / 2.0);
            } else {
                this.prevDiff = (Pos)((Pos)this.difference.clone()).normalize();
                this.sinPrev = 1.0f;
            }
            if (this.nextSegment != null) {
                Pos nextdiffnorm = (Pos)((Pos)this.nextSegment.difference.clone()).normalize();
                thisdiffnorm = (Pos)((Pos)this.difference.clone()).normalize();
                this.nextDiff = (Pos)((Pos)thisdiffnorm.add(nextdiffnorm)).normalize();
                this.sinNext = (float)Math.sin(thisdiffnorm.anglePreNorm((IPos3D)nextdiffnorm.multiply(-1.0)) / 2.0);
            } else {
                this.nextDiff = (Pos)((Pos)this.difference.clone()).normalize();
                this.sinNext = 1.0f;
            }
        }

        public String toString() {
            return this.startBolt.point.toString() + " " + this.endBolt.point.toString();
        }
    }

    public class BoltPoint {
        Pos point;
        Pos basePoint;
        Pos offSet;

        public BoltPoint(Pos basePoint, Pos offSet) {
            this.point = (Pos)((Pos)basePoint.clone()).add(offSet);
            this.basePoint = basePoint;
            this.offSet = offSet;
        }
    }
}

