/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.processors.multiblock;

import com.builtbroken.mc.framework.json.conversion.data.transform.JsonConverterPos;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.structure.MultiBlockLayout;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class JsonMultiBlockLayoutProcessor
extends JsonProcessor<MultiBlockLayout> {
    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "multiblock";
    }

    @Override
    public String getLoadOrder() {
        return null;
    }

    @Override
    public MultiBlockLayout process(JsonElement data) {
        JsonObject multiBlockData = data.getAsJsonObject();
        JsonMultiBlockLayoutProcessor.ensureValuesExist(multiBlockData, "key", "tiles");
        String key = multiBlockData.get("key").getAsString().toLowerCase();
        MultiBlockLayout layout = new MultiBlockLayout(this, key);
        JsonArray array = multiBlockData.get("tiles").getAsJsonArray();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) continue;
            JsonObject object = element.getAsJsonObject();
            if (object.has("pos")) {
                this.createPos(object, layout);
                continue;
            }
            if (object.has("for")) {
                this.doForLoop(object.getAsJsonObject("for"), layout, new HashMap<String, Integer>());
                continue;
            }
            throw new IllegalArgumentException("Unknown entry in multiblock array.");
        }
        return layout;
    }

    protected void doForLoop(JsonObject object, MultiBlockLayout layout, HashMap<String, Integer> map) {
        String key;
        JsonMultiBlockLayoutProcessor.ensureValuesExist(object, "start", "end");
        int start = object.getAsJsonPrimitive("start").getAsInt();
        int end = object.getAsJsonPrimitive("end").getAsInt();
        String string = key = object.has("id") ? object.getAsJsonPrimitive("id").getAsString() : "number";
        if (start >= end) {
            throw new IllegalArgumentException("Start can not be greater than or equal to end for a for loop.");
        }
        for (int i = start; i <= end; ++i) {
            map.put(key, i);
            if (object.has("multiblock")) {
                JsonObject template = object.getAsJsonObject("multiblock");
                JsonObject state = new JsonObject();
                this.replaceValues(template, state, map);
                this.createPos(state, layout);
                continue;
            }
            if (object.has("for")) {
                if (!object.has("id")) {
                    throw new IllegalArgumentException("Repeat for loops require ID be provide for each loop to iterate correctly.");
                }
                this.doForLoop(object.getAsJsonObject("for"), layout, map);
                continue;
            }
            throw new IllegalArgumentException("Loop was provided without data to create.");
        }
    }

    protected void replaceValues(JsonObject template, JsonObject state, HashMap<String, Integer> map) {
        for (Map.Entry entry : template.entrySet()) {
            if (entry.getValue() instanceof JsonPrimitive && ((JsonPrimitive)entry.getValue()).isString()) {
                String s = ((JsonElement)entry.getValue()).getAsString();
                if (s.contains("%")) {
                    for (Map.Entry<String, Integer> e : map.entrySet()) {
                        s = s.replace("%" + e.getKey() + "%", "" + e.getValue());
                    }
                }
                state.add((String)entry.getKey(), (JsonElement)new JsonPrimitive(s));
                continue;
            }
            if (entry.getValue() instanceof JsonObject) {
                JsonObject object = new JsonObject();
                this.replaceValues(((JsonElement)entry.getValue()).getAsJsonObject(), object, map);
                state.add((String)entry.getKey(), (JsonElement)object);
                continue;
            }
            state.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    protected void createPos(JsonObject object, MultiBlockLayout layout) {
        JsonMultiBlockLayoutProcessor.ensureValuesExist(object, "pos");
        Pos pos = JsonConverterPos.fromJson(object.get("pos"));
        String tile = EnumMultiblock.TILE.getTileName();
        String tileData = "";
        if (object.has("data")) {
            tileData = object.get("data").getAsString();
        }
        if (object.has("tile")) {
            tile = object.get("tile").getAsString();
        }
        layout.addTile(pos, tile + "#" + tileData);
    }
}

