/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.loading;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.loading.JsonLoader;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.override.JsonOverride;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class JsonProcessorInjectionMap<O> {
    public final HashMap<String, Field> injectionFields = new HashMap();
    public final HashMap<String, Method> injectionMethods = new HashMap();
    public final HashMap<String, String> injectionTypes = new HashMap();
    public final HashMap<String, String[]> injectionArgs = new HashMap();

    public JsonProcessorInjectionMap(Class clazz) {
        this.load(clazz);
    }

    protected void load(Class clazz) {
        String key;
        String[] values;
        boolean loadServer = Engine.shouldDoServerLogic();
        boolean loadClient = Engine.shouldDoClientLogic();
        List<Field> fields = ReflectionUtility.getAllFields(clazz);
        for (Field field : fields) {
            Annotation[] annotations = field.getDeclaredAnnotations();
            if (annotations == null || annotations.length <= 0) continue;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JsonProcessorData)) continue;
                JsonProcessorData jAnno = (JsonProcessorData)annotation;
                values = jAnno.value();
                if (values != null && (loadServer && jAnno.loadForServer() || loadClient && jAnno.loadForClient())) {
                    for (String keyValue : values) {
                        if (keyValue != null) {
                            key = keyValue.toLowerCase();
                            if (this.injectionFields.containsKey(key)) {
                                throw new NullPointerException("Duplicate key detected for  " + field + " owned by " + this.injectionFields.get(key));
                            }
                        } else {
                            throw new NullPointerException("Value for JsonProcessorData was null on " + field);
                        }
                        this.injectionFields.put(key, field);
                        this.cacheAnnotationData(key, jAnno);
                    }
                    continue;
                }
                throw new NullPointerException("Value for JsonProcessorData was null on " + field);
            }
        }
        List<Method> methods = ReflectionUtility.getMethods(clazz);
        for (Method method : methods) {
            Annotation[] annotations = method.getDeclaredAnnotations();
            if (annotations == null || annotations.length <= 0) continue;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JsonProcessorData)) continue;
                if (method.getParameterCount() != 1) {
                    throw new NullPointerException("Method " + method + " should only have 1 parameter to use JsonProcessorData tag");
                }
                values = ((JsonProcessorData)annotation).value();
                if (values != null) {
                    for (String keyValue : values) {
                        if (keyValue != null) {
                            key = keyValue.toLowerCase();
                            if (this.injectionMethods.containsKey(key)) {
                                throw new NullPointerException("Duplicate key detected for  " + method + " owned by " + this.injectionMethods.get(key));
                            }
                        } else {
                            throw new NullPointerException("Value for JsonProcessorData was null on " + method);
                        }
                        this.injectionMethods.put(key, method);
                        this.cacheAnnotationData(key, (JsonProcessorData)annotation);
                    }
                    continue;
                }
                throw new NullPointerException("Value for JsonProcessorData was null on " + method);
            }
        }
    }

    protected void cacheAnnotationData(String key, JsonProcessorData annotation) {
        if (annotation.type() != null && !annotation.type().equals("unknown")) {
            this.injectionTypes.put(key.toLowerCase(), annotation.type().toLowerCase());
        }
        if (annotation.args() != null && annotation.args().length > 0 && !annotation.args()[0].equals("")) {
            this.injectionArgs.put(key.toLowerCase(), annotation.args());
        }
    }

    public boolean supports(String keyValue, boolean override, String overrideType) {
        if (this.injectionFields.containsKey(keyValue) || this.injectionMethods.containsKey(keyValue)) {
            if (override) {
                Method method;
                Field field;
                Annotation[] annotations;
                if (this.injectionFields.containsKey(keyValue) && (annotations = (field = this.injectionFields.get(keyValue)).getDeclaredAnnotations()) != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        if (!(annotation instanceof JsonOverride)) continue;
                        return true;
                    }
                }
                if (this.injectionMethods.containsKey(keyValue) && (annotations = (method = this.injectionMethods.get(keyValue)).getDeclaredAnnotations()) != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        if (!(annotation instanceof JsonOverride)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean handle(O objectToInjection, String keyValue, Object valueToInject) {
        return this.handle(objectToInjection, keyValue, valueToInject, false, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handle(O objectToInjection, String keyValue, Object valueToInject, boolean override, String overrideType) {
        try {
            String injectionKeyID = keyValue.toLowerCase();
            if (!this.supports(injectionKeyID, override, overrideType)) return false;
            if (valueToInject instanceof JsonElement) {
                if (valueToInject instanceof JsonPrimitive) {
                    if (((JsonPrimitive)valueToInject).isBoolean()) {
                        Boolean bool = ((JsonPrimitive)valueToInject).getAsBoolean();
                        if (this.injectionFields.containsKey(injectionKeyID)) {
                            Field field = this.injectionFields.get(injectionKeyID);
                            try {
                                field.setAccessible(true);
                                field.setBoolean(objectToInjection, bool);
                                return true;
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Failed to access field " + field, e);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Unexpected error setting " + field + " with " + bool, e);
                            }
                        }
                        Method method = this.injectionMethods.get(injectionKeyID);
                        try {
                            method.setAccessible(true);
                            method.invoke(objectToInjection, bool);
                            return true;
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException("Failed to invoke method " + method + " with data " + bool, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("Failed to access method " + method, e);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unexpected error invoking " + method + " with " + bool, e);
                        }
                    }
                    if (((JsonPrimitive)valueToInject).isNumber()) {
                        if (this.injectionFields.containsKey(injectionKeyID)) {
                            Field field = this.injectionFields.get(injectionKeyID);
                            try {
                                field.setAccessible(true);
                                String type = this.injectionTypes.get(injectionKeyID);
                                if (type == null) throw new RuntimeException("Failed to get number type for " + field);
                                if (type.equals("int") || type.equals("integer")) {
                                    field.setInt(objectToInjection, ((JsonPrimitive)valueToInject).getAsInt());
                                    return true;
                                } else if (type.equals("byte")) {
                                    field.setByte(objectToInjection, ((JsonPrimitive)valueToInject).getAsByte());
                                    return true;
                                } else if (type.equals("short")) {
                                    field.setShort(objectToInjection, ((JsonPrimitive)valueToInject).getAsShort());
                                    return true;
                                } else if (type.equals("double")) {
                                    field.setDouble(objectToInjection, ((JsonPrimitive)valueToInject).getAsDouble());
                                    return true;
                                } else if (type.equals("float")) {
                                    field.setFloat(objectToInjection, ((JsonPrimitive)valueToInject).getAsFloat());
                                    return true;
                                } else {
                                    if (!type.equals("long")) throw new RuntimeException("Unknown number type for " + field);
                                    field.setLong(objectToInjection, ((JsonPrimitive)valueToInject).getAsLong());
                                }
                                return true;
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Failed to access field " + field, e);
                            }
                        }
                        Method method = this.injectionMethods.get(injectionKeyID);
                        try {
                            method.setAccessible(true);
                            String type = this.injectionTypes.get(injectionKeyID);
                            if (type == null) throw new RuntimeException("Failed to get type");
                            if (type.equals("int") || type.equals("integer")) {
                                method.invoke(objectToInjection, ((JsonPrimitive)valueToInject).getAsInt());
                                return true;
                            } else if (type.equals("byte")) {
                                method.invoke(objectToInjection, ((JsonPrimitive)valueToInject).getAsByte());
                                return true;
                            } else if (type.equals("short")) {
                                method.invoke(objectToInjection, ((JsonPrimitive)valueToInject).getAsShort());
                                return true;
                            } else if (type.equals("double")) {
                                method.invoke(objectToInjection, ((JsonPrimitive)valueToInject).getAsDouble());
                                return true;
                            } else if (type.equals("float")) {
                                method.invoke(objectToInjection, Float.valueOf(((JsonPrimitive)valueToInject).getAsFloat()));
                                return true;
                            } else {
                                if (!type.equals("long")) throw new RuntimeException("Unknown number type " + type);
                                method.invoke(objectToInjection, ((JsonPrimitive)valueToInject).getAsLong());
                            }
                            return true;
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException("Failed to invoke method " + method + " with data " + valueToInject, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("Failed to access method " + method, e);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error injecting " + valueToInject + " into method " + method, e);
                        }
                    }
                    if (!((JsonPrimitive)valueToInject).isString()) return false;
                    String string = ((JsonPrimitive)valueToInject).getAsString();
                    return this.handle(objectToInjection, keyValue, string);
                }
                if (this.injectionFields.containsKey(injectionKeyID)) {
                    Field field = this.injectionFields.get(injectionKeyID);
                    field.setAccessible(true);
                    try {
                        String type = this.injectionTypes.get(injectionKeyID);
                        if (type != null && JsonLoader.hasConverterFor(type)) {
                            JsonConverter converter = JsonLoader.getConversionHandler(type);
                            if (converter == null) throw new IllegalArgumentException("Field was marked as type[" + type + "] but a converter could not be found to use with " + field + ", data: " + objectToInjection);
                            Object conversion = converter.convert((JsonElement)valueToInject, this.injectionArgs.get(injectionKeyID));
                            if (conversion == null) throw new IllegalArgumentException("Field was marked as type[" + type + "] but could not be converted to inject into " + field + ", data: " + objectToInjection);
                            field.set(objectToInjection, conversion);
                            return true;
                        } else {
                            field.set(objectToInjection, valueToInject);
                        }
                        return true;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to access field " + field, e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unexpected error setting " + field + " with " + valueToInject, e);
                    }
                }
                Method method = this.injectionMethods.get(injectionKeyID);
                try {
                    method.setAccessible(true);
                    String type = this.injectionTypes.get(injectionKeyID);
                    if (type != null && JsonLoader.hasConverterFor(type)) {
                        JsonConverter converter = JsonLoader.getConversionHandler(type);
                        if (converter == null) throw new IllegalArgumentException("Method was marked as type[" + type + "] but a converter could not be found to use with " + method + ", data: " + objectToInjection);
                        Object conversion = converter.convert((JsonElement)valueToInject, this.injectionArgs.get(injectionKeyID));
                        if (conversion == null) throw new IllegalArgumentException("Method was marked as type[" + type + "] but could not be converted to inject into " + method + ", data: " + objectToInjection);
                        method.invoke(objectToInjection, conversion);
                        return true;
                    } else {
                        method.invoke(objectToInjection, valueToInject);
                    }
                    return true;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to invoke method " + method + " with data " + valueToInject, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to access method " + method, e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error invoking " + method + " with " + valueToInject, e);
                }
            }
            if (valueToInject instanceof String) {
                if (this.injectionFields.containsKey(injectionKeyID)) {
                    Field field = this.injectionFields.get(injectionKeyID);
                    try {
                        field.setAccessible(true);
                        field.set(objectToInjection, valueToInject);
                        return true;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to access field " + field, e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unexpected error setting " + field + " with " + valueToInject, e);
                    }
                }
                Method method = this.injectionMethods.get(injectionKeyID);
                try {
                    method.setAccessible(true);
                    method.invoke(objectToInjection, valueToInject);
                    return true;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to invoke method " + method + " with data " + valueToInject, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to access method " + method, e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error invoking " + method + " with " + valueToInject, e);
                }
            }
            if (this.injectionFields.containsKey(injectionKeyID)) {
                Field field = this.injectionFields.get(injectionKeyID);
                try {
                    field.setAccessible(true);
                    field.set(objectToInjection, valueToInject);
                    return true;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to access field " + field, e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error setting " + field + " with " + valueToInject, e);
                }
            }
            Method method = this.injectionMethods.get(injectionKeyID);
            try {
                method.setAccessible(true);
                method.invoke(objectToInjection, valueToInject);
                return true;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke method " + method + " with data " + valueToInject, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access method " + method, e);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error invoking " + method + " with " + valueToInject, e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to inject data " + valueToInject + " into " + objectToInjection, e);
        }
    }

    public <D extends IJsonGenObject> void enforceRequired(D objectToInject) throws IllegalAccessException {
        for (Field field : this.injectionFields.values()) {
            Annotation[] annotations = field.getDeclaredAnnotations();
            if (annotations == null || annotations.length <= 0) continue;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JsonProcessorData) || !((JsonProcessorData)annotation).required()) continue;
                if (!field.isAccessible()) {
                    Engine.logger().error("JsonProcessorInjectionMap: Failed to access field '" + field + "' to check required state.");
                    continue;
                }
                Object object = field.get(objectToInject);
                if (object != null) continue;
                throw new RuntimeException("JsonProcessorInjectionMap: Missing required value from JSON file '" + ((JsonProcessorData)annotation).value() + "'");
            }
        }
    }
}

