/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSpawnParticleStream
extends PacketType {
    public int dim;
    public Pos start;
    public Pos end;

    public PacketSpawnParticleStream() {
    }

    public PacketSpawnParticleStream(int dim, IPos3D pos, IPos3D pos2) {
        this.dim = dim;
        this.start = new Pos(pos);
        this.end = new Pos(pos2);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        this.start.writeByteBuf(buffer);
        this.end.writeByteBuf(buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.start = new Pos(buffer);
        this.end = new Pos(buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76574_g == this.dim) {
            double distance = this.start.distance(this.end);
            Pos direction = (Pos)((Pos)this.start.sub(this.end)).divide(distance);
            int particles = (int)(distance / 0.3);
            for (int l = 0; l < particles; ++l) {
                Pos next = (Pos)this.start.sub((IPos3D)direction.multiply(l));
                player.field_70170_p.func_72869_a("portal", next.x(), next.y(), next.z(), 0.0, 0.0, 0.0);
            }
        }
    }
}

