/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.netty;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketBiomeData;
import com.builtbroken.mc.core.network.packet.PacketEntity;
import com.builtbroken.mc.core.network.packet.PacketGui;
import com.builtbroken.mc.core.network.packet.PacketPlayerItem;
import com.builtbroken.mc.core.network.packet.PacketSelectionData;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticle;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleCircle;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleStream;
import com.builtbroken.mc.core.network.packet.PacketSpawnStream;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.callback.PacketAudio;
import com.builtbroken.mc.core.network.packet.callback.PacketBlast;
import com.builtbroken.mc.core.network.packet.callback.PacketOpenGUI;
import com.builtbroken.mc.core.network.packet.callback.chunk.PacketRequestData;
import com.builtbroken.mc.core.network.packet.callback.chunk.PacketSendData;
import com.builtbroken.mc.core.network.packet.user.PacketMouseClick;
import com.builtbroken.mc.core.network.packet.user.PacketPlayerItemMode;
import com.builtbroken.mc.framework.access.global.packets.PacketAccessGui;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class PacketHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public boolean silenceStackTrace = false;
    private int nextID = 0;

    public PacketHandler() {
        this.addPacket(PacketTile.class);
        this.addPacket(PacketEntity.class);
        this.addPacket(PacketPlayerItem.class);
        this.addPacket(PacketPlayerItemMode.class);
        this.addPacket(PacketSelectionData.class);
        this.addPacket(PacketSpawnParticle.class);
        this.addPacket(PacketSpawnStream.class);
        this.addPacket(PacketSpawnParticleCircle.class);
        this.addPacket(PacketBiomeData.class);
        this.addPacket(PacketSpawnParticleStream.class);
        this.addPacket(PacketMouseClick.class);
        this.addPacket(PacketBlast.class);
        this.addPacket(PacketAudio.class);
        this.addPacket(PacketOpenGUI.class);
        this.addPacket(PacketGui.class);
        this.addPacket(PacketAccessGui.class);
        this.addPacket(PacketSendData.class);
        this.addPacket(PacketRequestData.class);
    }

    public void addPacket(Class<? extends IPacket> clazz) {
        this.addDiscriminator(this.nextID++, clazz);
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket packet, ByteBuf target) throws Exception {
        try {
            packet.encodeInto(ctx, target);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                Engine.logger().error("Failed to encode packet " + packet, (Throwable)e);
            }
            Engine.logger().error("Failed to encode packet " + packet + " E: " + e.getMessage());
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket packet) {
        try {
            packet.decodeInto(ctx, source);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                Engine.logger().error("Failed to decode packet " + packet, (Throwable)e);
            }
            Engine.logger().error("Failed to decode packet " + packet + " E: " + e.getMessage());
        }
    }
}

