/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.deps;

import com.builtbroken.mc.core.deps.Dep;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileDownloader {
    public static void downloadDeps(Dep ... deps) {
        for (Dep dep : deps) {
            FileDownloader.downloadDep(dep);
        }
    }

    public static void downloadDep(Dep dep) {
        URL url = dep.getURL();
        if (url != null) {
            FileDownloader.downloadFromURL(url, dep.getOutputFolderPath(), dep.getFileName());
        }
    }

    public static void downloadFromURL(URL in, String out, String fileName) {
        try {
            Path outPath = Paths.get(out + "/" + fileName, new String[0]);
            if (!outPath.toFile().exists()) {
                Files.copy(in.openStream(), outPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

