/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.api.recipe;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.IMachineRecipeHandler;
import com.builtbroken.mc.api.recipe.RecipeRegisterResult;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum MachineRecipeType {
    ITEM_SMELTER("smelter"),
    ITEM_GRINDER("ore.grinder"),
    ITEM_CRUSHER("ore.crusher"),
    ITEM_WASHER("ore.washer"),
    ITEM_SAWMILL("sawmill"),
    ITEM_SALVAGER("salvager"),
    PLATE_PRESS("metal.press"),
    PLATE_ROLLER("metal.roller"),
    PLATE_RIVETER("metal.riveter"),
    FLUID_MIXER("fluid.mixer"),
    FLUID_SMELTER("fluid.smelter"),
    FLUID_SOLIDIFIER("fluid.solidifier"),
    FLUID_CAST("fluid.cast");

    private IMachineRecipeHandler handler;
    public final String INTERNAL_NAME;

    private MachineRecipeType(String name) {
        this.INTERNAL_NAME = name;
    }

    public IMachineRecipeHandler getHandler() {
        return this.handler;
    }

    public static IMachineRecipeHandler getHandler(String name) {
        for (MachineRecipeType type : MachineRecipeType.values()) {
            if (!type.INTERNAL_NAME.equalsIgnoreCase(name)) continue;
            return type.getHandler();
        }
        return null;
    }

    public void setHandler(IMachineRecipeHandler handler) {
        this.handler = handler;
    }

    public RecipeRegisterResult registerRecipe(IMachineRecipe recipe) {
        if (this.handler != null) {
            return this.handler.registerRecipe(recipe);
        }
        return RecipeRegisterResult.NO_HANDLER;
    }

    public Object getRecipe(float extra_chance, float fail_chance, Object ... items) {
        if (this.getHandler() != null) {
            return this.getHandler().getRecipe(items, extra_chance, fail_chance);
        }
        return null;
    }

    public ItemStack getItemStackRecipe(float extra_chance, float fail_chance, Object ... items) {
        return MachineRecipeType.toItemStack(this.getRecipe(extra_chance, fail_chance, items));
    }

    public static ItemStack toItemStack(Object result) {
        if (result instanceof ItemStack) {
            return (ItemStack)result;
        }
        if (result instanceof Block) {
            return new ItemStack((Block)result);
        }
        if (result instanceof Item) {
            return new ItemStack((Item)result);
        }
        return null;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

