/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import mcjty.rftools.blocks.shield.ShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.SolidShieldBlock;
import mcjty.rftools.render.DefaultISBRH;
import mcjty.rftools.render.TesseleratorAccessHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SolidShieldBlockRenderer
extends DefaultISBRH {
    public int getRenderId() {
        return SolidShieldBlock.RENDERID_SHIELDBLOCK;
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(x, y, z);
        Block camoBlock = shieldBlockTileEntity.getBlock();
        if (camoBlock != null) {
            try {
                int addedVertices = TesseleratorAccessHelper.getAddedVertices(Tessellator.field_78398_a);
                boolean rc = renderer.func_147805_b(camoBlock, x, y, z);
                if (!rc) {
                    return false;
                }
                int newAddedVertices = TesseleratorAccessHelper.getAddedVertices(Tessellator.field_78398_a);
                return addedVertices != newAddedVertices;
            }
            catch (Exception e) {
                return false;
            }
        }
        this.renderShield(world, x, y, z, block, shieldBlockTileEntity);
        return true;
    }

    private void renderShield(IBlockAccess world, int x, int y, int z, Block block, ShieldBlockTileEntity shieldBlockTileEntity) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78384_a(shieldBlockTileEntity.getShieldColor(), 180);
        tessellator.func_78372_c((float)x, (float)y, (float)z);
        tessellator.func_78380_c(240);
        IIcon[] icons = ((SolidShieldBlock)block).getIcons();
        IIcon icon = icons[(z & 1) * 2 + (x & 1)];
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.DOWN);
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.UP);
        icon = icons[(y & 1) * 2 + (x + z & 1)];
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.NORTH);
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.SOUTH);
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.WEST);
        SolidShieldBlockRenderer.addSideConditionally(world, x, y, z, block, tessellator, icon, ForgeDirection.EAST);
        tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }
}

