/*
 * Decompiled with CFR 0.152.
 */
package BloodStuff;

import BloodStuff.ILimitingLogic;
import BloodStuff.RoutingFocusLogic;
import BloodStuff.RoutingFocusPosAndFacing;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RoutingFocusParadigm {
    public List<RoutingFocusLogic> logicList = new LinkedList<RoutingFocusLogic>();
    public List<RoutingFocusPosAndFacing> locationList = new LinkedList<RoutingFocusPosAndFacing>();
    public int maximumAmount = 0;

    public void addRoutingFocusPosAndFacing(RoutingFocusPosAndFacing facing) {
        this.locationList.add(facing);
    }

    public void addLogic(RoutingFocusLogic logic) {
        if (logic instanceof ILimitingLogic) {
            this.maximumAmount += ((ILimitingLogic)((Object)logic)).getRoutingLimit();
        }
        this.logicList.add(logic);
    }

    public boolean doesItemMatch(ItemStack keyStack, ItemStack checkedStack) {
        boolean isGood = false;
        boolean isFirst = true;
        for (RoutingFocusLogic logic : this.logicList) {
            if (isFirst) {
                isGood = logic.getDefaultMatch(keyStack, checkedStack);
                isFirst = false;
                continue;
            }
            isGood = logic.doesItemMatch(isGood, keyStack, checkedStack);
        }
        return isGood;
    }

    public void clear() {
        this.logicList.clear();
        this.locationList.clear();
        this.maximumAmount = 0;
    }

    public void setMaximumAmount(int amt) {
        this.maximumAmount = amt;
    }

    public int getMaximumAmount() {
        return this.maximumAmount;
    }
}

