/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.tile;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.alchemy.energy.TileSegmentedReagentHandler;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tombenpotter.sanguimancy.api.objects.ICustomNBTTag;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruptionHelper;

public class TileCorruptionCrystallizer
extends TileSegmentedReagentHandler
implements ICustomNBTTag {
    public int corruptionStored = 0;
    public String owner;
    public boolean multiblockFormed;
    private NBTTagCompound customNBTTag = new NBTTagCompound();

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_72820_D() % 100L == 0L) {
                this.multiblockFormed = this.checkMultiblockTier(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (!this.owner.equals("")) {
                EntityPlayer player = SoulNetworkHandler.getPlayerForUsername((String)this.owner);
                this.removeAndStoreCorruption(this.field_145850_b, player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.owner = tagCompound.func_74779_i("owner");
        this.corruptionStored = tagCompound.func_74762_e("corruptionStored");
        this.multiblockFormed = tagCompound.func_74767_n("multiblockFormed");
        this.customNBTTag = tagCompound.func_74775_l("customNBTTag");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74778_a("owner", this.owner);
        tagCompound.func_74768_a("corruptionStored", this.corruptionStored);
        tagCompound.func_74757_a("multiblockFormed", this.multiblockFormed);
        tagCompound.func_74782_a("customNBTTag", (NBTBase)this.customNBTTag);
    }

    public boolean checkMultiblockTier(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y - 1, z + 1) == ModBlocks.blockMasterStone && world.func_147439_a(x + 1, y - 1, z - 1) == ModBlocks.blockMasterStone && world.func_147439_a(x - 1, y - 1, z + 1) == ModBlocks.blockMasterStone && world.func_147439_a(x - 1, y - 1, z - 1) == ModBlocks.blockMasterStone) {
            TEMasterStone waterStone1 = (TEMasterStone)world.func_147438_o(x + 1, y - 1, z + 1);
            TEMasterStone waterStone2 = (TEMasterStone)world.func_147438_o(x + 1, y - 1, z - 1);
            TEMasterStone waterStone3 = (TEMasterStone)world.func_147438_o(x - 1, y - 1, z + 1);
            TEMasterStone waterStone4 = (TEMasterStone)world.func_147438_o(x - 1, y - 1, z - 1);
            if (!waterStone1.getCurrentRitual().equals("") && waterStone1.getCurrentRitual().equals("AW001Water") && !waterStone2.getCurrentRitual().equals("") && waterStone2.getCurrentRitual().equals("AW001Water") && !waterStone3.getCurrentRitual().equals("") && waterStone3.getCurrentRitual().equals("AW001Water") && !waterStone4.getCurrentRitual().equals("") && waterStone4.getCurrentRitual().equals("AW001Water") && world.func_147439_a(x + 2, y - 2, z + 1) == ModBlocks.blockMasterStone && world.func_147439_a(x + 2, y - 2, z - 1) == ModBlocks.blockMasterStone && world.func_147439_a(x - 2, y - 2, z + 1) == ModBlocks.blockMasterStone && world.func_147439_a(x - 2, y - 2, z - 1) == ModBlocks.blockMasterStone && world.func_147439_a(x + 1, y - 2, z + 2) == ModBlocks.blockMasterStone && world.func_147439_a(x - 1, y - 2, z + 2) == ModBlocks.blockMasterStone && world.func_147439_a(x + 1, y - 2, z - 2) == ModBlocks.blockMasterStone && world.func_147439_a(x - 1, y - 2, z - 2) == ModBlocks.blockMasterStone) {
                TEMasterStone fireStone1 = (TEMasterStone)world.func_147438_o(x + 2, y - 2, z + 1);
                TEMasterStone fireStone2 = (TEMasterStone)world.func_147438_o(x + 2, y - 2, z - 1);
                TEMasterStone fireStone3 = (TEMasterStone)world.func_147438_o(x - 2, y - 2, z + 1);
                TEMasterStone fireStone4 = (TEMasterStone)world.func_147438_o(x - 2, y - 2, z - 1);
                TEMasterStone fireStone5 = (TEMasterStone)world.func_147438_o(x + 1, y - 2, z + 2);
                TEMasterStone fireStone6 = (TEMasterStone)world.func_147438_o(x - 1, y - 2, z + 2);
                TEMasterStone fireStone7 = (TEMasterStone)world.func_147438_o(x + 1, y - 2, z - 2);
                TEMasterStone fireStone8 = (TEMasterStone)world.func_147438_o(x - 1, y - 2, z - 2);
                if (!fireStone1.getCurrentRitual().equals("") && fireStone1.getCurrentRitual().equals("AW002Lava") && !fireStone2.getCurrentRitual().equals("") && fireStone2.getCurrentRitual().equals("AW002Lava") && !fireStone3.getCurrentRitual().equals("") && fireStone3.getCurrentRitual().equals("AW002Lava") && !fireStone4.getCurrentRitual().equals("") && fireStone4.getCurrentRitual().equals("AW002Lava") && !fireStone5.getCurrentRitual().equals("") && fireStone5.getCurrentRitual().equals("AW002Lava") && !fireStone6.getCurrentRitual().equals("") && fireStone6.getCurrentRitual().equals("AW002Lava") && !fireStone7.getCurrentRitual().equals("") && fireStone7.getCurrentRitual().equals("AW002Lava") && !fireStone8.getCurrentRitual().equals("") && fireStone8.getCurrentRitual().equals("AW002Lava")) {
                    return true;
                }
            }
        }
        return false;
    }

    public void removeAndStoreCorruption(World world, EntityPlayer player, int x, int y, int z) {
        if (player != null) {
            if (this.canDrainReagent(ReagentRegistry.sanctusReagent, 20)) {
                if (SoulCorruptionHelper.isCorruptionOver(player, 1) && world.func_72820_D() % 200L == 0L) {
                    this.drain(ForgeDirection.UNKNOWN, 20, true);
                    SoulCorruptionHelper.decrementCorruption(player);
                    ++this.corruptionStored;
                    SoulNetworkHandler.syphonFromNetwork((String)player.func_70005_c_(), (int)500);
                } else if (this.corruptionStored > 0 && this.canDrainReagent(ReagentRegistry.sanctusReagent, 5) && world.func_72820_D() % 200L == 0L) {
                    this.drain(ForgeDirection.UNKNOWN, 5, true);
                    SoulNetworkHandler.syphonFromNetwork((String)player.func_70005_c_(), (int)50);
                }
            } else if (this.corruptionStored > 0 && world.func_72820_D() % 100L == 0L) {
                SoulCorruptionHelper.incrementCorruption(player);
                --this.corruptionStored;
            }
        }
    }

    public final Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canDrainReagent(Reagent reagent, int amount) {
        if (reagent == null || amount == 0) {
            return false;
        }
        ReagentStack reagentStack = new ReagentStack(reagent, amount);
        ReagentStack stack = this.drain(ForgeDirection.UNKNOWN, reagentStack, false);
        return stack != null && stack.amount >= amount;
    }

    @Override
    public NBTTagCompound getCustomNBTTag() {
        return this.customNBTTag;
    }

    @Override
    public void setCustomNBTTag(NBTTagCompound tag) {
        this.customNBTTag = tag;
    }
}

