/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import elec332.core.main.ElecCore;
import elec332.core.network.AbstractPacket;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class NetworkHandler {
    private String channelName;
    private int i;
    private SimpleNetworkWrapper networkWrapper;

    public NetworkHandler(String channelName) {
        this(channelName, 0);
    }

    public NetworkHandler(String channelName, int start) {
        if (start < 0) {
            throw new IllegalArgumentException();
        }
        this.channelName = channelName.toLowerCase();
        this.networkWrapper = new SimpleNetworkWrapper(this.channelName);
        this.i = start;
    }

    public void setMessageIndex(int newIndex) {
        if (newIndex >= this.i) {
            this.i = newIndex;
            return;
        }
        throw new IllegalArgumentException();
    }

    public void registerServerPacket(Class<? extends AbstractPacket> packetClass) {
        this.register(packetClass, Side.SERVER);
    }

    public void registerClientPacket(Class<? extends AbstractPacket> packetClass) {
        this.register(packetClass, Side.CLIENT);
    }

    public void registerServerPacket(AbstractPacket packet) {
        this.register(packet, Side.SERVER);
    }

    public void registerClientPacket(AbstractPacket packet) {
        this.register(packet, Side.CLIENT);
    }

    public <M extends IMessage, R extends IMessage> void registerPacket(Class<? extends IMessageHandler<M, R>> messageHandler, Class<M> messageType, Side side) {
        this.networkWrapper.registerMessage(messageHandler, messageType, this.i, side);
        ++this.i;
    }

    public void registerPacket(Class packetClass, Side side) {
        if (!this.checkValidity(packetClass)) {
            throw new IllegalArgumentException();
        }
        this.register(packetClass, side);
    }

    private boolean checkValidity(Class packet) {
        if (NetworkHandler.isValidPacket(packet)) {
            if (ElecCore.Debug) {
                ElecCore.instance.info("Validated packet: " + packet.getName());
            }
            return true;
        }
        return false;
    }

    public SimpleNetworkWrapper getNetworkWrapper() {
        return this.networkWrapper;
    }

    public String getChannelName() {
        return this.channelName;
    }

    private void register(Class packetClass, Side side) {
        this.networkWrapper.registerMessage(packetClass, packetClass, this.i, side);
        ++this.i;
    }

    private void register(AbstractPacket packet, Side side) {
        this.networkWrapper.registerMessage((IMessageHandler)packet, packet.getClass(), this.i, side);
        ++this.i;
    }

    public static boolean isValidPacket(Class clazz) {
        boolean b1 = clazz.getName().contains("Packet") && !Modifier.isAbstract(clazz.getModifiers());
        boolean b2 = false;
        boolean b3 = false;
        ArrayList interfaces = Lists.newArrayList((Object[])clazz.getInterfaces());
        for (Class toCheck = clazz.getSuperclass(); toCheck != null; toCheck = toCheck.getSuperclass()) {
            interfaces.addAll(Lists.newArrayList((Object[])toCheck.getInterfaces()));
        }
        for (Class interfaceClass : interfaces) {
            if (interfaceClass.equals(IMessage.class)) {
                b2 = true;
            }
            if (!interfaceClass.equals(IMessageHandler.class)) continue;
            b3 = true;
        }
        return b1 && b2 && b3;
    }
}

