/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock.dynamic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.multiblock.dynamic.AbstractDynamicMultiBlockWorldHolder;
import elec332.core.multiblock.dynamic.IDynamicMultiBlockTile;
import elec332.core.util.BlockLoc;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class AbstractDynamicMultiBlock<A extends AbstractDynamicMultiBlockWorldHolder<A, M>, M extends AbstractDynamicMultiBlock<A, M>> {
    protected final World world;
    private final int hash;
    private final UUID identifier;
    protected List<BlockLoc> allLocations;

    public AbstractDynamicMultiBlock(TileEntity tile, A worldHolder) {
        if (tile == null || !((AbstractDynamicMultiBlockWorldHolder)worldHolder).isTileValid(tile) || !(tile instanceof IDynamicMultiBlockTile) || tile.func_145831_w() == null) {
            throw new IllegalArgumentException("Invalid tile!");
        }
        this.identifier = UUID.randomUUID();
        this.hash = new Random().nextInt(Integer.MAX_VALUE);
        this.world = tile.func_145831_w();
        this.allLocations = Lists.newArrayList();
        this.allLocations.add(new BlockLoc(tile));
    }

    public void tick() {
    }

    public final List<BlockLoc> getAllLocations() {
        return ImmutableList.copyOf(this.allLocations);
    }

    protected void mergeWith(M multiBlock) {
        this.allLocations.addAll(((AbstractDynamicMultiBlock)multiBlock).allLocations);
    }

    protected void onTileRemoved(TileEntity tile) {
    }

    protected void invalidate() {
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && ((AbstractDynamicMultiBlock)obj).identifier.equals(this.identifier) && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }
}

