/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractBlockRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    protected final Block block;
    final Class<? extends TileEntity> tileClass;
    int renderID = -1;
    private final Tessellator tessellator = Tessellator.field_78398_a;

    public AbstractBlockRenderer(Block block) {
        this(block, null);
    }

    public AbstractBlockRenderer(Class<? extends TileEntity> tileClass) {
        this(null, tileClass);
    }

    public AbstractBlockRenderer(Block block, Class<? extends TileEntity> tileClass) {
        this.block = block;
        this.tileClass = tileClass;
    }

    public final boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public final boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public final void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(item, type, (RenderBlocks)data[0]);
    }

    public final void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public final boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.validForRendering(modelId) && this.doRenderInWorld(world, x, y, z, null, renderer, 0.0f, false);
    }

    public final boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    protected boolean validForRendering(int i) {
        return i == this.renderID;
    }

    public final int getRenderId() {
        return this.renderID;
    }

    public final void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        this.doRenderInWorld((IBlockAccess)tile.func_145831_w(), x, y, z, tile, RenderBlocks.getInstance(), partialTicks, true);
    }

    private boolean doRenderInWorld(IBlockAccess world, double x, double y, double z, TileEntity tile, RenderBlocks renderer, float partialTicks, boolean tesr) {
        this.tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        return this.renderBlockAt(world, x, y, z, tile, renderer, partialTicks, tesr);
    }

    protected abstract boolean renderBlockAt(IBlockAccess var1, double var2, double var4, double var6, TileEntity var8, RenderBlocks var9, float var10, boolean var11);

    protected abstract void renderItem(ItemStack var1, IItemRenderer.ItemRenderType var2, RenderBlocks var3);

    protected abstract boolean isISBRH();

    protected abstract boolean isItemRenderer();

    protected abstract boolean isTESR();
}

