/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.world_gen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderWorldGen;
import net.shadowmage.ancientwarfare.structure.world_gen.StructureEntry;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldGenTickHandler;

public class WorldStructureGenerator
implements IWorldGenerator {
    public static final HashSet<String> defaultTargetBlocks = new HashSet();
    public static final WorldStructureGenerator INSTANCE;
    private final Random rng = new Random();

    private WorldStructureGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ChunkCoordinates cc = world.func_72861_E();
        float distSq = cc.func_71569_e(chunkX * 16, cc.field_71572_b, chunkZ * 16);
        if (AWStructureStatics.withinProtectionRange(distSq)) {
            return;
        }
        if (this.rng.nextFloat() < AWStructureStatics.randomGenerationChance) {
            WorldGenTickHandler.INSTANCE.addChunkForGeneration(world, chunkX, chunkZ);
        }
    }

    public void generateAt(int chunkX, int chunkZ, World world) {
        if (world == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        long seed = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
        this.rng.setSeed(seed);
        int x = chunkX * 16 + this.rng.nextInt(16);
        int z = chunkZ * 16 + this.rng.nextInt(16);
        int y = WorldStructureGenerator.getTargetY(world, x, z, false) + 1;
        if (y <= 0) {
            return;
        }
        int face = this.rng.nextInt(4);
        world.field_72984_F.func_76320_a("AWTemplateSelection");
        StructureTemplate template = WorldGenStructureManager.INSTANCE.selectTemplateForGeneration(world, this.rng, x, y, z, face);
        world.field_72984_F.func_76319_b();
        AWLog.logDebug("Template selection took: " + (System.currentTimeMillis() - t1) + " ms.");
        if (template == null) {
            return;
        }
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        if (map == null) {
            return;
        }
        world.field_72984_F.func_76320_a("AWTemplateGeneration");
        if (this.attemptStructureGenerationAt(world, x, y, z, face, template, map)) {
            AWLog.log(String.format("Generated structure: %s at %s, %s, %s, time: %sms", template.name, x, y, z, System.currentTimeMillis() - t1));
        }
        world.field_72984_F.func_76319_b();
    }

    public static int getTargetY(World world, int x, int z, boolean skipWater) {
        for (int y = world.func_72940_L(); y > 0; --y) {
            Block block = world.func_147439_a(x, y, z);
            if (AWStructureStatics.skippableBlocksContains(block) || skipWater && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) continue;
            return y;
        }
        return -1;
    }

    public static void sprinkleSnow(World world, StructureBB bb, int border) {
        BlockPosition p1 = bb.min.offset(-border, 0, -border);
        BlockPosition p2 = bb.max.offset(border, 0, border);
        for (int x = p1.x; x <= p2.x; ++x) {
            for (int z = p1.z; z <= p2.z; ++z) {
                Block block;
                int y = world.func_72874_g(x, z) - 1;
                if (p2.y < y || y <= 0 || !world.canSnowAtBody(x, y + 1, z, true) || (block = world.func_147439_a(x, y, z)) == Blocks.field_150350_a || !block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP)) continue;
                world.func_147449_b(x, y + 1, z, Blocks.field_150431_aC);
            }
        }
    }

    public static int getStepNumber(int x, int z, int minX, int maxX, int minZ, int maxZ) {
        int steps = 0;
        if (x < minX - 1) {
            steps += minX - 1 - x;
        } else if (x > maxX + 1) {
            steps += x - (maxX + 1);
        }
        if (z < minZ - 1) {
            steps += minZ - 1 - z;
        } else if (z > maxZ + 1) {
            steps += z - (maxZ + 1);
        }
        return steps;
    }

    public final boolean attemptStructureGenerationAt(World world, int x, int y, int z, int face, StructureTemplate template, StructureMap map) {
        TownMap townMap;
        int zs;
        long t1 = System.currentTimeMillis();
        int prevY = y;
        StructureBB bb = new StructureBB(x, y, z, face, template.xSize, template.ySize, template.zSize, template.xOffset, template.yOffset, template.zOffset);
        y = template.getValidationSettings().getAdjustedSpawnY(world, x, y, z, face, template, bb);
        bb.min = bb.min.moveUp(y - prevY);
        bb.max = bb.max.moveUp(y - prevY);
        int xs = bb.getXSize();
        int size = (xs > (zs = bb.getZSize()) ? xs : zs) / 16 + 3;
        if (map != null) {
            Collection<StructureEntry> bbCheckList = map.getEntriesNear(world, x, z, size, true, new ArrayList<StructureEntry>());
            for (StructureEntry entry : bbCheckList) {
                if (!bb.crossWith(entry.getBB())) continue;
                return false;
            }
        }
        if ((townMap = AWGameData.INSTANCE.getPerWorldData(world, TownMap.class)) != null && townMap.intersectsWithTown(bb)) {
            AWLog.logDebug("Skipping structure generation: " + template.name + " at: " + bb + " for intersection with existing town");
            return false;
        }
        if (template.getValidationSettings().validatePlacement(world, x, y, z, face, template, bb)) {
            AWLog.logDebug("Validation took: " + (System.currentTimeMillis() - t1) + " ms");
            this.generateStructureAt(world, x, y, z, face, template, map);
            return true;
        }
        return false;
    }

    private void generateStructureAt(World world, int x, int y, int z, int face, StructureTemplate template, StructureMap map) {
        if (map != null) {
            map.setGeneratedAt(world, x, y, z, face, new StructureEntry(x, y, z, face, template), template.getValidationSettings().isUnique());
        }
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilderWorldGen(world, template, face, x, y, z));
    }

    static {
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150346_d));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock((Block)Blocks.field_150349_c));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150348_b));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock((Block)Blocks.field_150354_m));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150351_n));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150322_A));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150435_aG));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150366_p));
        defaultTargetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150365_q));
        INSTANCE = new WorldStructureGenerator();
    }
}

