/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

public enum Direction {
    SOUTH(0, 1),
    WEST(-1, 0),
    NORTH(0, -1),
    EAST(1, 0);

    public final int xDirection;
    public final int zDirection;

    private Direction(int x, int z) {
        this.xDirection = x;
        this.zDirection = z;
    }

    public Direction getLeft() {
        int o = this.ordinal() - 1;
        if (o < 0) {
            o = Direction.values().length - 1;
        }
        return Direction.values()[o];
    }

    public Direction getRight() {
        int o = this.ordinal() + 1;
        if (o >= Direction.values().length) {
            o = 0;
        }
        return Direction.values()[o];
    }

    public Direction getOpposite() {
        int o = (this.ordinal() + 2) % 4;
        return Direction.values()[o];
    }

    public static final Direction fromFacing(int face) {
        return Direction.values()[face];
    }
}

