/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.save;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class TemplateExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportTo(StructureTemplate template, File directory) {
        File exportFile = new File(directory, template.name + "." + AWStructureStatics.templateExtension);
        if (!exportFile.exists()) {
            try {
                exportFile.createNewFile();
            }
            catch (IOException e) {
                AWLog.logError("Could not export template..could not create file : " + exportFile.getAbsolutePath());
                e.printStackTrace();
                return false;
            }
        }
        BufferedWriter writer = null;
        try {
            TemplateRule[] templateRules;
            writer = new BufferedWriter(new FileWriter(exportFile));
            TemplateExporter.writeHeader(template, writer);
            TemplateExporter.writeValidationSettings(template.getValidationSettings(), writer);
            TemplateExporter.writeLayers(template, writer);
            writer.write("#### RULES ####");
            writer.newLine();
            for (TemplateRule rule : templateRules = template.getTemplateRules()) {
                StructurePluginManager.writeRuleLines(rule, writer, "rule");
            }
            writer.write("#### ENTITIES ####");
            writer.newLine();
            for (TemplateRule rule : templateRules = template.getEntityRules()) {
                StructurePluginManager.writeRuleLines(rule, writer, "entity");
            }
        }
        catch (IOException e) {
            AWLog.logError("Could not export template..could not create file : " + exportFile.getAbsolutePath());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    AWLog.logError("Could not export template..could not close file : " + exportFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private static void writeValidationSettings(StructureValidator settings, BufferedWriter writer) throws IOException {
        writer.write("#### VALIDATION ####");
        writer.newLine();
        writer.write("validation:");
        writer.newLine();
        StructureValidator.writeValidator(writer, settings);
        writer.write(":endvalidation");
        writer.newLine();
        writer.newLine();
    }

    private static void writeHeader(StructureTemplate template, BufferedWriter writer) throws IOException {
        Calendar cal = Calendar.getInstance();
        writer.write("# Ancient Warfare Structure Template File");
        writer.newLine();
        writer.write("# Auto-generated structure template file. created on: " + (cal.get(2) + 1) + "/" + cal.get(5) + "/" + cal.get(1) + " at: " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13));
        writer.newLine();
        writer.write("# Lines beginning with # denote comments");
        writer.newLine();
        writer.newLine();
        writer.write("header:");
        writer.newLine();
        writer.write("version=2.1");
        writer.newLine();
        writer.write("name=" + template.name);
        writer.newLine();
        writer.write("size=" + template.xSize + "," + template.ySize + "," + template.zSize);
        writer.newLine();
        writer.write("offset=" + template.xOffset + "," + template.yOffset + "," + template.zOffset);
        writer.newLine();
        writer.write(":endheader");
        writer.newLine();
        writer.newLine();
    }

    private static void writeLayers(StructureTemplate template, BufferedWriter writer) throws IOException {
        writer.write("#### LAYERS ####");
        writer.newLine();
        for (int y = 0; y < template.ySize; ++y) {
            writer.write("layer: " + y);
            writer.newLine();
            for (int z = 0; z < template.zSize; ++z) {
                for (int x = 0; x < template.xSize; ++x) {
                    short data = template.getTemplateData()[StructureTemplate.getIndex(x, y, z, template.xSize, template.ySize, template.zSize)];
                    writer.write(String.valueOf(data));
                    if (x >= template.xSize - 1) continue;
                    writer.write(",");
                }
                writer.newLine();
            }
            writer.write(":endlayer");
            writer.newLine();
        }
        writer.newLine();
    }
}

