/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.StructureEntry;

public class WorldGenStructureManager {
    private HashMap<String, Set<StructureTemplate>> templatesByBiome = new HashMap();
    List<StructureEntry> searchCache = new ArrayList<StructureEntry>();
    List<StructureTemplate> trimmedPotentialStructures = new ArrayList<StructureTemplate>();
    HashMap<String, Integer> distancesFound = new HashMap();
    BlockPosition rearBorderPos = new BlockPosition(0, 0, 0);
    public static final WorldGenStructureManager INSTANCE = new WorldGenStructureManager();

    private WorldGenStructureManager() {
    }

    public void loadBiomeList() {
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            BiomeGenBase biome = BiomeGenBase.func_150565_n()[i];
            if (biome == null) continue;
            String name = AWStructureStatics.getBiomeName(biome);
            this.templatesByBiome.put(name, new HashSet());
        }
    }

    public void registerWorldGenStructure(StructureTemplate template) {
        StructureValidator validation = template.getValidationSettings();
        Set<String> biomes = validation.getBiomeList();
        if (validation.isBiomeWhiteList()) {
            for (String biome : biomes) {
                if (this.templatesByBiome.containsKey(biome.toLowerCase(Locale.ENGLISH))) {
                    this.templatesByBiome.get(biome.toLowerCase(Locale.ENGLISH)).add(template);
                    continue;
                }
                AWLog.logError("Could not locate biome: " + biome + " while registering template: " + template.name + " for world generation.");
            }
        } else {
            for (String biome : this.templatesByBiome.keySet()) {
                if (!biomes.isEmpty() && biomes.contains(biome.toLowerCase(Locale.ENGLISH))) continue;
                this.templatesByBiome.get(biome).add(template);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public StructureTemplate selectTemplateForGeneration(World world, Random rng, int x, int y, int z, int face) {
        void var22_30;
        this.searchCache.clear();
        this.trimmedPotentialStructures.clear();
        this.distancesFound.clear();
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        if (map == null) {
            return null;
        }
        int foundValue = 0;
        BiomeGenBase biome = world.func_72807_a(x, z);
        String biomeName = AWStructureStatics.getBiomeName(biome);
        Collection<StructureEntry> duplicateSearchEntries = map.getEntriesNear(world, x, z, AWStructureStatics.duplicateStructureSearchRange, false, this.searchCache);
        for (StructureEntry structureEntry : duplicateSearchEntries) {
            float mx = structureEntry.getBB().getCenterX() - x;
            float mz = structureEntry.getBB().getCenterZ() - z;
            float foundDistance = MathHelper.func_76129_c((float)(mx * mx + mz * mz));
            int chunkDistance = (int)(foundDistance / 16.0f);
            if (this.distancesFound.containsKey(structureEntry.getName())) {
                int dist = this.distancesFound.get(structureEntry.getName());
                if (chunkDistance >= dist) continue;
                this.distancesFound.put(structureEntry.getName(), chunkDistance);
                continue;
            }
            this.distancesFound.put(structureEntry.getName(), chunkDistance);
        }
        Collection<StructureEntry> clusterValueSearchEntries = map.getEntriesNear(world, x, z, AWStructureStatics.clusterValueSearchRange, false, this.searchCache);
        for (StructureEntry entry : clusterValueSearchEntries) {
            foundValue += entry.getValue();
        }
        Set<StructureTemplate> set = this.templatesByBiome.get(biomeName.toLowerCase(Locale.ENGLISH));
        if (set == null || set.isEmpty()) {
            return null;
        }
        int remainingValueCache = AWStructureStatics.maxClusterValue - foundValue;
        int dim = world.field_73011_w.field_76574_g;
        for (StructureTemplate structureTemplate : set) {
            int dist;
            StructureValidator settings = structureTemplate.getValidationSettings();
            boolean dimensionMatch = !settings.isDimensionWhiteList();
            for (int i = 0; i < settings.getAcceptedDimensions().length; ++i) {
                int dimTest = settings.getAcceptedDimensions()[i];
                if (dimTest != dim) continue;
                dimensionMatch = !dimensionMatch;
                break;
            }
            if (!dimensionMatch || settings.isUnique() && map.isGeneratedUnique(structureTemplate.name) || settings.getClusterValue() > remainingValueCache || this.distancesFound.containsKey(structureTemplate.name) && (dist = this.distancesFound.get(structureTemplate.name).intValue()) < settings.getMinDuplicateDistance() || !settings.shouldIncludeForSelection(world, x, y, z, face, structureTemplate)) continue;
            this.trimmedPotentialStructures.add(structureTemplate);
        }
        if (this.trimmedPotentialStructures.isEmpty()) {
            return null;
        }
        int totalWeight = 0;
        for (StructureTemplate t : this.trimmedPotentialStructures) {
            totalWeight += t.getValidationSettings().getSelectionWeight();
        }
        totalWeight -= rng.nextInt(totalWeight + 1);
        Object var22_29 = null;
        Iterator<StructureTemplate> iterator = this.trimmedPotentialStructures.iterator();
        while (iterator.hasNext()) {
            StructureTemplate t;
            StructureTemplate structureTemplate = t = iterator.next();
            if ((totalWeight -= t.getValidationSettings().getSelectionWeight()) > 0) continue;
            break;
        }
        this.distancesFound.clear();
        this.trimmedPotentialStructures.clear();
        return var22_30;
    }
}

