/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.gate;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.model.ModelGateBasic;
import org.lwjgl.opengl.GL11;

public class RenderGateBasic
extends Render {
    protected final ModelGateBasic model = new ModelGateBasic();

    public final void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        float width;
        GL11.glPushMatrix();
        EntityGate g = (EntityGate)entity;
        BlockPosition min = this.getMin(g);
        BlockPosition max = this.getMax(g);
        boolean wideOnXAxis = min.x != max.x;
        float height = max.y - min.y + 1;
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        float tx = 0.0f;
        float ty = -1.0f;
        float tz = 0.0f;
        float axisRotation = 0.0f;
        if (wideOnXAxis) {
            width = max.x - min.x + 1;
            xOffset = width * 0.5f - 0.5f;
            tx = 1.0f;
            axisRotation = 90.0f;
        } else {
            tz = 1.0f;
            width = max.z - min.z + 1;
            zOffset = -width * 0.5f + 0.5f;
        }
        GL11.glTranslatef((float)(-xOffset), (float)0.0f, (float)zOffset);
        int y = 0;
        while ((float)y < height) {
            GL11.glPushMatrix();
            int x = 0;
            while ((float)x < width) {
                this.model.setModelRotation(axisRotation);
                if ((float)y == height - 1.0f && x > 0 && (float)x < width - 1.0f) {
                    this.model.renderTop();
                } else if ((float)y == height - 1.0f && x == 0) {
                    this.model.renderCorner();
                } else if ((float)y == height - 1.0f && (float)x == width - 1.0f) {
                    this.model.setModelRotation(axisRotation + 180.0f);
                    this.model.renderCorner();
                } else if (x == 0) {
                    this.model.renderSide();
                } else if ((float)x == width - 1.0f) {
                    this.model.setModelRotation(axisRotation + 180.0f);
                    this.model.renderSide();
                }
                this.postRender(g, x, width, y, height, wideOnXAxis, axisRotation, f1);
                GL11.glTranslatef((float)tx, (float)0.0f, (float)tz);
                ++x;
            }
            GL11.glPopMatrix();
            GL11.glTranslatef((float)0.0f, (float)ty, (float)0.0f);
            ++y;
        }
        GL11.glPopMatrix();
    }

    protected BlockPosition getMin(EntityGate gate) {
        return gate.pos1;
    }

    protected BlockPosition getMax(EntityGate gate) {
        return gate.pos2;
    }

    protected void postRender(EntityGate gate, int x, float width, int y, float height, boolean wideOnXAxis, float axisRotation, float frame) {
        if ((float)y + gate.edgePosition <= height - 0.475f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-gate.edgePosition - gate.openingSpeed * (1.0f - frame)), (float)0.0f);
            this.model.setModelRotation(axisRotation);
            if (gate.getGateType().getModelType() == 0) {
                this.model.renderSolidWall();
            } else {
                this.model.renderBars();
            }
            GL11.glPopMatrix();
        }
    }

    protected final ResourceLocation func_110775_a(Entity entity) {
        return ((EntityGate)entity).getGateType().getTexture();
    }
}

